/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "connection.h"
#include "handler_common.h"
#include "handler_file.h"
#include "handler_dirlist.h"


ret_t 
cherokee_handler_common_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	struct stat            info;
	cherokee_connection_t *conn = CONN(cnt);


	cherokee_buffer_add (conn->local_directory, conn->request->buf, conn->request->len);

	/* Request is a directory
	 */
	if ((stat (conn->local_directory->buf, &info) == 0) && S_ISDIR(info.st_mode)) {
		int is_file;

		/* Have an index file inside?
		 */
		cherokee_buffer_add (conn->local_directory, "/index.html", 11);
		is_file = ((stat (conn->local_directory->buf, &info) == 0) && S_ISREG(info.st_mode));
		cherokee_buffer_drop_endding (conn->local_directory, 11);
		cherokee_buffer_drop_endding (conn->local_directory, conn->request->len);

		if (is_file) {			
			cherokee_buffer_add (conn->request, "/index.html", 11);
			return cherokee_handler_file_new (hdl, cnt, properties);
		} else {
			return cherokee_handler_dirlist_new (hdl, cnt, properties);
		} 
	}


        /* File handler
	 */
	cherokee_buffer_drop_endding (conn->local_directory, conn->request->len);
	return cherokee_handler_file_new (hdl, cnt, properties);
}



/* Library init function
 */

static int _common_is_init = 0;

void
common_init (void)
{
	if (_common_is_init)
		return;

	/* Init the dependences
	 */
	file_init();
	dirlist_init();

	_common_is_init = 1;
}
