/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "encoder.h"


ret_t 
cherokee_encoder_load (char *prefix, encoder_func_new_t *func)
{
	*func = NULL;
}



ret_t 
cherokee_encoder_init (cherokee_encoder_t *enc)
{
	enc->free        = NULL;
	enc->encode      = NULL;
	enc->add_headers = NULL;

	return ret_ok;
}


ret_t 
cherokee_encoder_free (cherokee_encoder_t *enc)
{
	if (enc->free) {
		return enc->free (enc);
	}

	return ret_error;
}


ret_t
cherokee_encoder_add_headers (cherokee_encoder_t *enc, cherokee_buffer_t *buf)
{
	if (enc->add_headers) {
		return enc->add_headers (enc, buf);
	}

	return ret_error;
}


ret_t 
cherokee_encoder_encode (cherokee_encoder_t *enc, 
			 cherokee_buffer_t  *in, 
			 cherokee_buffer_t  *out)
{
	if (enc->encode) {
		return enc->encode (enc, in, out);
	}

	return ret_error;
}
