/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_TABLE_H__
#define __CHEROKEE_TABLE_H__

#include "avl.h"
#include "common.h"

typedef struct {
	struct avl_table *tree;
} cherokee_table_t;


typedef void (* cherokee_table_free_item_t) (void *item);


#define TABLE(x) ((cherokee_table_t *)(x))

ret_t cherokee_table_new  (cherokee_table_t **tab);
ret_t cherokee_table_init (cherokee_table_t  *tab);

ret_t cherokee_table_free (cherokee_table_t  *tab);
ret_t cherokee_table_free2(cherokee_table_t  *tab, cherokee_table_free_item_t func);

ret_t cherokee_table_clean (cherokee_table_t  *tab);
ret_t cherokee_table_clean2(cherokee_table_t  *tab, cherokee_table_free_item_t func);

ret_t cherokee_table_add   (cherokee_table_t  *tab, char *key, void *value);
void* cherokee_table_get   (cherokee_table_t  *tab, char *key);
void* cherokee_table_del   (cherokee_table_t  *tab, char *key);

#endif /* __CHEROKEE_TABLE_H__ */
