%{
/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "plugin_table_entry.h"
#include "read_config_yacc.h"

#include <stdio.h>
#include <string.h>
%}

%option yylineno

ws              [ \t]+
integer         -?[0-9]+
comment         #.*$
fpath           \/[^\"\{\}\n ]*
qstring         \"[^\"\{\}\n]*\"
http            http\:\/\/[a-zA-Z0-9\$\-_\.\&\=\;\/\?]*
id              [_\-\.a-zA-Z][\.\-_a-zA-Z0-9]*
ip_end          [0-9]*[0-9]+
ip_part         [0-2]*{ip_end}
ip              {ip_part}\.{ip_part}\.{ip_part}\.{ip_part}
nl              [\n\r]

%%

"Handler"      { return T_HANDLER; }
"Port"         { return T_PORT; }
"DocumentRoot" { return T_DOCUMENT_ROOT; }
"Log"          { return T_LOG; }
"Timeout"      { return T_TIMEOUT; }
"MimeFile"     { return T_MIME_FILE; }
"Directory"    { return T_DIRECTORY; }
"KeepAlive"    { return T_KEEPALIVE; }
"User"         { return T_USER; }
"Group"        { return T_GROUP; }
"Server"       { return T_SERVER; }
"UserDir"      { return T_USERDIR; }
"FileDir"      { return T_FILEDIR; }
"PidFile"      { return T_PIDFILE; }
"Listen"       { return T_LISTEN; }
"url"          { return T_URL; }
"On"           { yylval.number = 1; return T_NUMBER; }
"Off"          { yylval.number = 0; return T_NUMBER; }

{http}         { yylval.string = strdup(yytext); return T_HTTP_URL; }
{id}           { yylval.string = strdup(yytext); return T_ID; }
{ip}           { yylval.string = strdup(yytext); return T_IP; }
{fpath}        { yylval.string = strdup(yytext); return T_FULLDIR; }
{qstring}      { yylval.string = strdup(yytext); return T_QSTRING; }

{integer}      { yylval.number = atoi(yytext); return T_NUMBER; }

{comment}      ;
{nl}           ;
{ws}           ;

.		     { return yytext[0]; }

%%

int 
yywrap()
{
       return 1;
}

