/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_HANDLER = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_POLICY = 274,
     T_SERVER = 275,
     T_USERDIR = 276,
     T_PIDFILE = 277,
     T_LISTEN = 278,
     T_SERVER_TOKENS = 279,
     T_ENCODER = 280,
     T_ALLOW = 281,
     T_IO_CACHE = 282,
     T_DIRECTORYINDEX = 283,
     T_ICONS = 284,
     T_AUTH = 285,
     T_NAME = 286,
     T_METHOD = 287,
     T_PASSWDFILE = 288,
     T_SSL_CA_LIST_FILE = 289,
     T_FROM = 290,
     T_SOCKET = 291,
     T_LOG_FLUSH_INTERVAL = 292,
     T_INCLUDE = 293,
     T_PANIC_ACTION = 294,
     T_JUST_ABOUT = 295,
     T_LISTEN_QUEUE_SIZE = 296,
     T_SENDFILE = 297,
     T_MINSIZE = 298,
     T_MAXSIZE = 299,
     T_MAX_FDS = 300,
     T_SHOW = 301,
     T_CHROOT = 302,
     T_ONLY_SECURE = 303,
     T_MAX_CONNECTION_REUSE = 304,
     T_REWRITE = 305,
     T_POLL_METHOD = 306,
     T_EXTENSION = 307,
     T_IPV6 = 308,
     T_ENV = 309,
     T_NUMBER = 310,
     T_PORT = 311,
     T_PORT_TLS = 312,
     T_QSTRING = 313,
     T_FULLDIR = 314,
     T_ID = 315,
     T_HTTP_URL = 316,
     T_HTTPS_URL = 317,
     T_HOSTNAME = 318,
     T_IP = 319,
     T_DOMAIN_NAME = 320,
     T_ADDRESS_PORT = 321
   };
#endif
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_HANDLER 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_POLICY 274
#define T_SERVER 275
#define T_USERDIR 276
#define T_PIDFILE 277
#define T_LISTEN 278
#define T_SERVER_TOKENS 279
#define T_ENCODER 280
#define T_ALLOW 281
#define T_IO_CACHE 282
#define T_DIRECTORYINDEX 283
#define T_ICONS 284
#define T_AUTH 285
#define T_NAME 286
#define T_METHOD 287
#define T_PASSWDFILE 288
#define T_SSL_CA_LIST_FILE 289
#define T_FROM 290
#define T_SOCKET 291
#define T_LOG_FLUSH_INTERVAL 292
#define T_INCLUDE 293
#define T_PANIC_ACTION 294
#define T_JUST_ABOUT 295
#define T_LISTEN_QUEUE_SIZE 296
#define T_SENDFILE 297
#define T_MINSIZE 298
#define T_MAXSIZE 299
#define T_MAX_FDS 300
#define T_SHOW 301
#define T_CHROOT 302
#define T_ONLY_SECURE 303
#define T_MAX_CONNECTION_REUSE 304
#define T_REWRITE 305
#define T_POLL_METHOD 306
#define T_EXTENSION 307
#define T_IPV6 308
#define T_ENV 309
#define T_NUMBER 310
#define T_PORT 311
#define T_PORT_TLS 312
#define T_QSTRING 313
#define T_FULLDIR 314
#define T_ID 315
#define T_HTTP_URL 316
#define T_HTTPS_URL 317
#define T_HOSTNAME 318
#define T_IP 319
#define T_DOMAIN_NAME 320
#define T_ADDRESS_PORT 321




/* Copy the first part of user declarations.  */


/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#ifdef HAVE_PWD_H
# include <pwd.h>
#endif

#ifdef HAVE_GRP_H
# include <grp.h>
#endif

#include "table.h"
#include "mime.h"
#include "server.h"
#include "server-protected.h"
#include "virtual_server.h"
#include "dirs_table_entry.h"
#include "encoder.h"
#include "logger_table.h"
#include "access.h"
#include "list_ext.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)

typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *list;
} YYSTYPE;
/* Line 190 of yacc.c.  */

# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* What is the right way to import this prototipe?
 */
extern int yylex (void);


extern char *yytext;
extern int   yylineno;

char                                   *current_yacc_file           = NULL;
static cherokee_dirs_table_t           *current_dirs_table          = NULL;
static cherokee_dirs_table_entry_t     *current_dirs_table_entry    = NULL;
static cherokee_virtual_server_t       *current_virtual_server      = NULL;
static cherokee_encoder_table_entry_t  *current_encoder_entry       = NULL;
static cherokee_module_info_t          *current_module_info         = NULL;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;

struct {
	   char                           *handler_name;
	   cherokee_dirs_table_entry_t    *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_dirs_table_t          *dirs;
	   char                           *document_root;
	   char                           *directory_name;
} directory_content_tmp;

struct {
	   char                           *handler_name;
	   cherokee_dirs_table_entry_t    *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_exts_table_t          *exts;
	   char                           *document_root;
	   linked_list_t                  *exts_list;
} extension_content_tmp;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)
#define auto_dirs_table     ((current_dirs_table) ? current_dirs_table : &(auto_virtual_server)->dirs)


static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new;
	   int   new_len;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new_len = (*len) + 2;
	   new  = (char*) malloc (new_len);

	   *len = snprintf (new, new_len, "%s/", string);

	   free (string);
	   return new;
}

static char *
make_slash_end (char *string)
{
	   int len = strlen(string);
	   return make_finish_with_slash (string, &len);
}

static cherokee_dirs_table_entry_t *
dirs_table_entry_new (void)
{
	   cherokee_dirs_table_entry_t *entry;

	   cherokee_dirs_table_entry_new (&entry);
	   current_dirs_table_entry = entry;

	   return entry;
}

static char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}

static int
load_module (cherokee_module_loader_t *loader, char *name, cherokee_module_info_t **info)
{
	   ret_t ret;

	   ret = cherokee_module_loader_load (loader, name);
	   if (ret < ret_ok) {
			 PRINT_MSG("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }
	   
	   ret = cherokee_module_loader_get_info (loader, name, info);
	   if (ret < ret_ok) {
			 PRINT_MSG("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }

	   return 0;
}


static void
handler_redir_add_property (cherokee_dirs_table_entry_t *entry, char *regex, char *subs, int show)
{
	   int     regex_len;
	   int     subs_len;
	   char   *p;
	   char   *serialized;
	   list_t *plist        = NULL;
	   list_t  nlist        = LIST_HEAD_INIT(nlist);

	   /* Build the string:
	    * [1]show [s]regex \0 [s]subs \0
	    */
	   regex_len = strlen(regex);
	   subs_len = strlen(subs);

	   serialized = (char *) malloc (1 + regex_len + 1 + subs_len + 1);
	   memset (serialized, 0, regex_len + subs_len + 3);

	   p = serialized;

	   *p = show;
	   p++;

	   strncpy (p, regex, regex_len);
	   p += regex_len + 1;
	   
	   strncpy (p, subs, subs_len);
	   
	   /* Add it to the list
	    */
	   if (entry->properties != NULL) {
			 cherokee_typed_table_get_list (entry->properties, "regex_list", &plist);
	   }

	   if (plist == NULL) {
			 cherokee_list_add (&nlist, serialized);
			 cherokee_dirs_table_entry_set_prop (entry, "regex_list", typed_list, &nlist, 
										  (cherokee_typed_free_func_t) cherokee_list_free_item_simple);
	   } else {
			 cherokee_list_add_tail (plist, serialized);
	   }
}


static void
dirs_table_set_prop (cherokee_dirs_table_entry_t *dir_entry, char *prop, char *value)
{
	   cherokee_dirs_table_entry_set_prop (dir_entry, prop, typed_str, value, NULL);
}


void
yyerror (char* msg)
{
	   char *config;

	   config = (current_yacc_file) ? current_yacc_file : "";

        PRINT_MSG("Error parsing file %s:%d '%s', symbol '%s'\n", 
			   config, yylineno, msg, yytext);
}



/* Line 213 of yacc.c.  */


#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  123
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   213

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  70
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  83
/* YYNRULES -- Number of rules. */
#define YYNRULES  168
/* YYNRULES -- Number of states. */
#define YYNSTATES  255

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   321

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    67,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    68,     2,    69,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    95,    98,
      99,   102,   103,   106,   107,   110,   111,   114,   115,   118,
     119,   122,   124,   126,   128,   132,   134,   138,   140,   144,
     146,   148,   150,   154,   157,   160,   163,   166,   169,   172,
     173,   178,   179,   183,   184,   187,   190,   193,   196,   199,
     202,   205,   208,   211,   214,   217,   218,   223,   227,   228,
     231,   234,   237,   240,   243,   246,   251,   254,   257,   260,
     263,   266,   270,   274,   275,   278,   281,   284,   287,   290,
     293,   299,   302,   304,   306,   311,   315,   317,   319,   321,
     323,   325,   327,   330,   334,   337,   339,   342,   345,   348,
     351,   353,   355,   357,   358,   365,   366,   373,   374,   381,
     383,   386,   392,   396,   398,   401,   404,   408,   412,   413,
     414,   417,   420,   421,   428,   431,   432,   436,   437
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
      71,     0,    -1,    -1,    72,    -1,    74,    -1,    72,    74,
      -1,    76,    -1,    73,    76,    -1,    76,    -1,    75,    -1,
     136,    -1,    90,    -1,    91,    -1,    92,    -1,   101,    -1,
     102,    -1,   103,    -1,   104,    -1,   105,    -1,   106,    -1,
     114,    -1,   127,    -1,   128,    -1,   129,    -1,   130,    -1,
     122,    -1,   123,    -1,   126,    -1,    93,    -1,    94,    -1,
     115,    -1,   116,    -1,   117,    -1,   118,    -1,   120,    -1,
     121,    -1,   140,    -1,   138,    -1,   151,    -1,    95,    -1,
     149,    -1,    96,    -1,   110,    -1,   107,    -1,   108,    -1,
     109,    -1,   147,    -1,    -1,    77,   142,    -1,    -1,    78,
     119,    -1,    -1,    79,   133,    -1,    -1,    80,   113,    -1,
      -1,    81,   125,    -1,    -1,    82,   143,    -1,    -1,    83,
     140,    -1,    60,    -1,    59,    -1,    84,    -1,    84,    67,
      85,    -1,    60,    -1,    60,    67,    86,    -1,   135,    -1,
     135,    67,    87,    -1,    64,    -1,    60,    -1,    88,    -1,
      88,    67,    89,    -1,    56,    55,    -1,    57,    55,    -1,
      23,   135,    -1,    37,    55,    -1,    51,    60,    -1,    12,
      59,    -1,    -1,    13,    60,    97,    98,    -1,    -1,    68,
      99,    69,    -1,    -1,    99,   100,    -1,    60,    59,    -1,
      24,    60,    -1,    14,    59,    -1,    29,    59,    -1,    10,
      55,    -1,    11,    55,    -1,     8,    55,    -1,     7,    59,
      -1,     6,    59,    -1,    34,    59,    -1,    -1,    25,    60,
     111,   112,    -1,    68,    80,    69,    -1,    -1,    26,    86,
      -1,     4,    86,    -1,    22,    59,    -1,    38,    59,    -1,
      39,    59,    -1,    41,    55,    -1,    42,    68,    78,    69,
      -1,    43,    55,    -1,    44,    55,    -1,    45,    55,    -1,
      49,    55,    -1,    47,    59,    -1,     5,    55,   124,    -1,
      68,    81,    69,    -1,    -1,    19,    60,    -1,    53,    55,
      -1,    17,    60,    -1,    17,    55,    -1,    18,    60,    -1,
      18,    55,    -1,    16,    60,    68,    79,    69,    -1,    16,
      60,    -1,    61,    -1,    62,    -1,    46,    50,    58,    58,
      -1,    50,    58,    58,    -1,    60,    -1,    59,    -1,    66,
      -1,    58,    -1,    61,    -1,    62,    -1,    60,   134,    -1,
      54,    60,   134,    -1,    36,    59,    -1,    40,    -1,    20,
      66,    -1,    27,    55,    -1,    55,   132,    -1,    46,    86,
      -1,    60,    -1,    64,    -1,    65,    -1,    -1,    20,    87,
      68,   137,    73,    69,    -1,    -1,    52,    86,    68,   139,
      77,    69,    -1,    -1,    15,    59,    68,   141,    77,    69,
      -1,   131,    -1,    12,    59,    -1,    30,    86,    68,    82,
      69,    -1,    26,    35,    89,    -1,    48,    -1,    31,    58,
      -1,    17,    86,    -1,    32,    60,   144,    -1,    68,   145,
      69,    -1,    -1,    -1,   145,   146,    -1,    33,    59,    -1,
      -1,    21,    60,   148,    68,    83,    69,    -1,    28,    85,
      -1,    -1,    68,    79,    69,    -1,    -1,     9,    60,   152,
     150,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   296,   296,   297,   300,   301,   304,   305,   308,   309,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   353,   354,   356,
     357,   359,   360,   362,   363,   365,   366,   368,   369,   371,
     372,   377,   378,   380,   389,   401,   410,   422,   431,   443,
     443,   445,   454,   463,   468,   473,   478,   483,   501,   523,
     522,   548,   549,   551,   552,   555,   568,   586,   591,   596,
     604,   609,   614,   631,   648,   667,   666,   697,   698,   700,
     721,   742,   761,   766,   776,   781,   783,   788,   793,   798,
     803,   808,   815,   816,   818,   834,   839,   854,   859,   874,
     879,   885,   891,   892,   894,   899,   904,   905,   906,   907,
     908,   909,   914,   943,   979,   982,   985,   988,   991,  1004,
    1033,  1034,  1035,  1041,  1040,  1078,  1077,  1164,  1163,  1235,
    1242,  1255,  1279,  1298,  1307,  1320,  1341,  1361,  1362,  1365,
    1366,  1369,  1375,  1374,  1403,  1417,  1418,  1421,  1420
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM",
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS",
  "T_ERROR_HANDLER", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT",
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP",
  "T_POLICY", "T_SERVER", "T_USERDIR", "T_PIDFILE", "T_LISTEN",
  "T_SERVER_TOKENS", "T_ENCODER", "T_ALLOW", "T_IO_CACHE",
  "T_DIRECTORYINDEX", "T_ICONS", "T_AUTH", "T_NAME", "T_METHOD",
  "T_PASSWDFILE", "T_SSL_CA_LIST_FILE", "T_FROM", "T_SOCKET",
  "T_LOG_FLUSH_INTERVAL", "T_INCLUDE", "T_PANIC_ACTION", "T_JUST_ABOUT",
  "T_LISTEN_QUEUE_SIZE", "T_SENDFILE", "T_MINSIZE", "T_MAXSIZE",
  "T_MAX_FDS", "T_SHOW", "T_CHROOT", "T_ONLY_SECURE",
  "T_MAX_CONNECTION_REUSE", "T_REWRITE", "T_POLL_METHOD", "T_EXTENSION",
  "T_IPV6", "T_ENV", "T_NUMBER", "T_PORT", "T_PORT_TLS", "T_QSTRING",
  "T_FULLDIR", "T_ID", "T_HTTP_URL", "T_HTTPS_URL", "T_HOSTNAME", "T_IP",
  "T_DOMAIN_NAME", "T_ADDRESS_PORT", "','", "'{'", "'}'", "$accept",
  "conffile", "lines", "server_lines", "line", "common_line",
  "server_line", "directory_options", "sendfile_options",
  "handler_options", "encoder_options", "thread_options", "auth_options",
  "directories", "id_or_path", "id_path_list", "id_list", "domain_list",
  "ip_or_domain", "ip_list", "port", "port_tls", "listen",
  "log_flush_interval", "poll_method", "document_root", "log", "@1",
  "log_optional", "tuple_list", "tuple", "server_tokens", "mime", "icons",
  "timeout", "keepalive", "keepalive_max_requests", "ssl_file",
  "ssl_key_file", "ssl_ca_list_file", "encoder", "@2",
  "maybe_encoder_options", "encoder_option", "pidfile", "include",
  "panic_action", "listen_queue_size", "sendfile", "sendfile_option",
  "maxfds", "maxconnectionreuse", "chroot", "thread_number",
  "maybe_thread_options", "thread_option", "ipv6", "user1", "user2",
  "group1", "group2", "handler", "http_generic", "handler_option",
  "str_type", "host_name", "server", "@3", "extension", "@4", "directory",
  "@5", "directory_option", "auth_option", "maybe_auth_option_params",
  "auth_option_params", "auth_option_param", "userdir", "@6",
  "directoryindex", "maybe_handlererror_options", "errorhandler", "@7", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,    44,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    70,    71,    71,    72,    72,    73,    73,    74,    74,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    77,    77,    78,
      78,    79,    79,    80,    80,    81,    81,    82,    82,    83,
      83,    84,    84,    85,    85,    86,    86,    87,    87,    88,
      88,    89,    89,    90,    91,    92,    93,    94,    95,    97,
      96,    98,    98,    99,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   111,   110,   112,   112,   113,
     113,   114,   115,   116,   117,   118,   119,   119,   120,   121,
     122,   123,   124,   124,   125,   126,   127,   128,   129,   130,
     131,   131,   132,   132,   133,   133,   134,   134,   134,   134,
     134,   134,   133,   133,   133,   133,   133,   133,   133,   133,
     135,   135,   135,   137,   136,   139,   138,   141,   140,   142,
     142,   142,   142,   142,   143,   143,   143,   144,   144,   145,
     145,   146,   148,   147,   149,   150,   150,   152,   151
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     2,     0,
       2,     0,     2,     0,     2,     0,     2,     0,     2,     0,
       2,     1,     1,     1,     3,     1,     3,     1,     3,     1,
       1,     1,     3,     2,     2,     2,     2,     2,     2,     0,
       4,     0,     3,     0,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     0,     4,     3,     0,     2,
       2,     2,     2,     2,     2,     4,     2,     2,     2,     2,
       2,     3,     3,     0,     2,     2,     2,     2,     2,     2,
       5,     2,     1,     1,     4,     3,     1,     1,     1,     1,
       1,     1,     2,     3,     2,     1,     2,     2,     2,     2,
       1,     1,     1,     0,     6,     0,     6,     0,     6,     1,
       2,     5,     3,     1,     2,     2,     3,     3,     0,     0,
       2,     2,     0,     6,     2,     0,     3,     0,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     3,     4,     9,
       8,    11,    12,    13,    28,    29,    39,    41,    14,    15,
      16,    17,    18,    19,    43,    44,    45,    42,    20,    30,
      31,    32,    33,    34,    35,    25,    26,    27,    21,    22,
      23,    24,    10,    37,    36,    46,    40,    38,   113,    93,
      92,    91,   167,    89,    90,    78,    79,    87,     0,   117,
     116,   119,   118,   140,   141,   142,     0,    67,   162,   101,
      75,    86,    95,    62,    61,    63,   164,    88,    94,    76,
     102,   103,   104,    49,   108,   110,   109,    77,    65,     0,
     115,    73,    74,     1,     5,    55,   111,   165,    81,   147,
     143,     0,     0,    98,     0,     0,     0,   145,     0,    51,
     168,    83,    80,    47,     0,    68,    59,    53,    96,    64,
       0,     0,   105,    50,    66,    47,     0,   112,    56,     0,
       0,     0,     0,     6,     0,     0,   106,   107,     0,   114,
       0,     0,     0,   135,     0,     0,     0,     0,     0,   166,
      52,     0,    82,    84,     0,     0,     0,     0,   153,   148,
     149,    48,   144,     7,   163,    60,     0,     0,    97,    54,
     146,   136,   137,   134,     0,   139,     0,     0,   122,   123,
     138,   129,   127,   126,   130,   131,   128,   132,    85,   150,
     121,     0,     0,   100,    99,     0,   125,   133,    51,    70,
      69,    71,   152,    57,   124,     0,     0,     0,   120,    72,
       0,     0,     0,   151,    58,   155,   154,   158,   159,   156,
       0,     0,   157,   160,   161
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    36,    37,   162,    38,    39,    40,   161,   135,   159,
     165,   138,   237,   164,   105,   106,   119,    96,   231,   232,
      41,    42,    43,    44,    45,    46,    47,   128,   142,   160,
     183,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,   133,   148,   199,    58,    59,    60,    61,    62,   153,
      63,    64,    65,    66,   126,   158,    67,    68,    69,    70,
      71,   190,   210,   180,   217,    97,    72,   144,    73,   155,
      74,   143,   191,   244,   249,   250,   253,    75,   132,    76,
     140,    77,   127
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -138
static const short int yypact[] =
{
      77,   -22,   -14,   -10,    -2,    -1,     8,    13,    11,     9,
      19,    21,    -8,     7,   -21,    33,    37,   -21,    43,    47,
     -47,    49,    50,    55,    53,    54,    62,   -11,    66,    64,
      70,    72,    75,    82,    84,    86,   142,    77,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,    76,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,    80,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,    81,    78,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,    85,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,    89,    90,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,    91,    94,  -138,
    -138,   -21,    95,    96,   -47,   -28,    75,  -138,   -15,  -138,
    -138,  -138,  -138,  -138,   161,  -138,  -138,  -138,  -138,  -138,
      88,    98,  -138,  -138,  -138,  -138,   112,  -138,  -138,   100,
     -23,     2,    -4,  -138,    -5,    -3,  -138,  -138,    10,  -138,
     109,   122,   119,  -138,   -31,   121,   123,    -6,    15,  -138,
    -138,   125,  -138,  -138,   126,   127,   146,    75,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,    75,    75,  -138,  -138,
    -138,  -138,  -138,  -138,   130,  -138,   132,    15,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
     124,   -33,   128,  -138,  -138,   133,  -138,  -138,  -138,  -138,
    -138,   131,  -138,  -138,  -138,   111,   -33,     3,  -138,  -138,
      75,   135,   134,  -138,  -138,  -138,  -138,   129,  -138,  -138,
     -27,   140,  -138,  -138,  -138
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -138,  -138,  -138,  -138,   163,  -138,  -137,    46,  -138,   -26,
    -138,  -138,  -138,  -138,  -138,    69,  -136,    73,  -138,   -30,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138,  -138,     0,   188,  -138,  -138,  -138,  -138,
      44,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,  -138,
    -138,  -138,  -138
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
     154,   196,     2,     3,   156,     5,   251,   163,     8,     9,
      11,    11,   103,   104,   184,   150,   151,    15,   185,   204,
     240,    19,   184,   197,    20,   193,   185,   229,   186,   118,
      22,   230,   187,    78,   241,   242,   186,   181,   205,    93,
     187,   152,   252,    94,    95,    79,   182,    89,    32,    80,
     188,   222,    90,    81,   157,   208,   209,   113,   188,    82,
     223,   224,    91,    83,   194,   192,   198,    92,    84,    86,
      85,   189,   243,   211,   212,   213,   214,   215,    87,   200,
      88,   216,     1,     2,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    98,    12,    13,    99,    14,    15,    16,
      17,    18,    19,   101,   245,    20,    21,   102,   107,   108,
     109,    22,   110,   111,    23,    24,    25,   112,    26,    27,
     170,   114,    28,   115,    29,   116,    30,   171,    31,    32,
      33,   170,   117,    34,    35,   118,   172,   120,   171,   121,
     173,   122,   123,   166,   125,   131,   174,   172,   129,   130,
     175,   173,   134,   167,   176,   177,   136,   174,   137,   139,
     178,   175,   141,   146,   147,   176,   177,     2,     3,   179,
       5,   178,   169,     8,     9,   201,    11,   202,   203,   206,
     238,   221,    15,   207,   218,   219,    19,   220,   225,    20,
     226,   234,   228,   246,   247,    22,   233,   248,   236,   254,
     124,   168,   235,   149,   145,   100,   239,   227,   195,     0,
       0,     0,     0,    32
};

static const short int yycheck[] =
{
     136,     4,     6,     7,    19,     9,    33,   144,    12,    13,
      15,    15,    59,    60,    12,    43,    44,    21,    16,    50,
      17,    25,    12,    26,    28,   162,    16,    60,    26,    60,
      34,    64,    30,    55,    31,    32,    26,    60,   174,    60,
      30,    69,    69,    64,    65,    59,    69,    55,    52,    59,
      48,   187,    60,    55,    69,    61,    62,    68,    48,    60,
     196,   197,    55,    55,    69,    69,    69,    60,    55,    60,
      59,    69,    69,    58,    59,    60,    61,    62,    59,    69,
      59,    66,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    60,    17,    18,    59,    20,    21,    22,
      23,    24,    25,    60,   240,    28,    29,    60,    59,    59,
      55,    34,    59,    59,    37,    38,    39,    55,    41,    42,
      20,    55,    45,    59,    47,    55,    49,    27,    51,    52,
      53,    20,    60,    56,    57,    60,    36,    55,    27,    55,
      40,    55,     0,    55,    68,    67,    46,    36,    68,    68,
      50,    40,    67,    55,    54,    55,    67,    46,    68,    68,
      60,    50,    68,    68,    68,    54,    55,     6,     7,    69,
       9,    60,    60,    12,    13,    66,    15,    55,    59,    58,
      69,    35,    21,    60,    59,    59,    25,    60,    58,    28,
      58,    58,    68,    58,    60,    34,    68,    68,    67,    59,
      37,   155,   228,   134,   131,    17,   236,   207,   164,    -1,
      -1,    -1,    -1,    52
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    20,    21,    22,    23,    24,    25,
      28,    29,    34,    37,    38,    39,    41,    42,    45,    47,
      49,    51,    52,    53,    56,    57,    71,    72,    74,    75,
      76,    90,    91,    92,    93,    94,    95,    96,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   114,   115,
     116,   117,   118,   120,   121,   122,   123,   126,   127,   128,
     129,   130,   136,   138,   140,   147,   149,   151,    55,    59,
      59,    55,    60,    55,    55,    59,    60,    59,    59,    55,
      60,    55,    60,    60,    64,    65,    87,   135,    60,    59,
     135,    60,    60,    59,    60,    84,    85,    59,    59,    55,
      59,    59,    55,    68,    55,    59,    55,    60,    60,    86,
      55,    55,    55,     0,    74,    68,   124,   152,    97,    68,
      68,    67,   148,   111,    67,    78,    67,    68,    81,    68,
     150,    68,    98,   141,   137,    87,    68,    68,   112,    85,
      43,    44,    69,   119,    86,   139,    19,    69,   125,    79,
      99,    77,    73,    76,    83,    80,    55,    55,    77,    60,
      20,    27,    36,    40,    46,    50,    54,    55,    60,    69,
     133,    60,    69,   100,    12,    16,    26,    30,    48,    69,
     131,   142,    69,    76,    69,   140,     4,    26,    69,   113,
      69,    66,    55,    59,    50,    86,    58,    60,    61,    62,
     132,    58,    59,    60,    61,    62,    66,   134,    59,    59,
      60,    35,    86,    86,    86,    58,    58,   134,    68,    60,
      64,    88,    89,    68,    58,    79,    67,    82,    69,    89,
      17,    31,    32,    69,   143,    86,    58,    60,    68,   144,
     145,    33,    69,   146,    59
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 61:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 62:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 63:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = (yyvsp[0].string);
	   
	   (yyval.list) = n;
}
    break;

  case 64:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 65:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = (yyvsp[0].string);
	   
	   (yyval.list) = n;
}
    break;

  case 66:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 67:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = (yyvsp[0].string);
	   
	   (yyval.list) = n;
}
    break;

  case 68:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 71:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = NULL;
	   n->string = (yyvsp[0].string);

	   (yyval.list) = n;
}
    break;

  case 72:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 73:

    {
	   SRV(server)->port = (yyvsp[0].number);
}
    break;

  case 74:

    {
	   SRV(server)->port_tls = (yyvsp[0].number);
}
    break;

  case 75:

    {
	   SRV(server)->listen_to = (yyvsp[0].string);
}
    break;

  case 76:

    {
	   SRV(server)->log_flush_elapse = (yyvsp[0].number);
}
    break;

  case 77:

    {
	   if (strcmp((yyvsp[0].string), "epoll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_epoll;
	   } else if (strcmp((yyvsp[0].string), "port") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_port;
	   } else if (strcmp((yyvsp[0].string), "kqueue") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_kqueue;
	   } else if (strcmp((yyvsp[0].string), "poll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_poll;
	   } else if (strcmp((yyvsp[0].string), "select") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_select;
	   } else {
			 PRINT_MSG ("ERROR: Unknown polling method '%s'\n", (yyvsp[0].string));
			 return 1;
	   }
}
    break;

  case 78:

    {
	   char                      *root;
	   int                        root_len;
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;

	   root     = (yyvsp[0].string);
	   root_len = strlen((yyvsp[0].string));

	   /* Check for the endding slash
	    */
	   root = make_finish_with_slash (root, &root_len);

	   /* Add the virtual root path to the virtual server struct
	    */
	   cherokee_buffer_add (vserver->root, root, root_len);
}
    break;

  case 79:

    {
	   ret_t ret;

	   /* Maybe load the module
	    */
	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[0].string));
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Can't load logger module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }

	   cherokee_module_loader_get_info (&SRV(server)->loader, (yyvsp[0].string), &current_module_info);
}
    break;

  case 80:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, (yyvsp[-2].string), current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 85:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_typed_table_add_str (vserver->logger_props, (yyvsp[-1].string), (yyvsp[0].string));
}
    break;

  case 86:

    {
	   if (!strncasecmp("Product", (yyvsp[0].string), 7)) {
			 SRV(server)->server_token = cherokee_version_product;
	   } else if (!strncasecmp("Minor", (yyvsp[0].string), 5)) {
			 SRV(server)->server_token = cherokee_version_minor;
	   } else if (!strncasecmp("Minimal", (yyvsp[0].string), 7)) {
			 SRV(server)->server_token = cherokee_version_minimal;
	   } else if (!strncasecmp("OS", (yyvsp[0].string), 2)) {
			 SRV(server)->server_token = cherokee_version_os;
	   } else if (!strncasecmp("Full", (yyvsp[0].string), 4)) {
			 SRV(server)->server_token = cherokee_version_full;
	   } else {
			 PRINT_MSG ("ERROR: Unknown server token '%s'\n", (yyvsp[0].string));
			 return 1;
	   }
}
    break;

  case 87:

    {
	   SRV(server)->mime_file = (yyvsp[0].string);
}
    break;

  case 88:

    {
	   SRV(server)->icons_file = (yyvsp[0].string);
}
    break;

  case 89:

    {
	   SRV(server)->timeout = (yyvsp[0].number);

	   cherokee_buffer_clean  (SRV(server)->timeout_header);
	   cherokee_buffer_add_va (SRV(server)->timeout_header, "Keep-Alive: timeout=%d"CRLF, (yyvsp[0].number));
}
    break;

  case 90:

    {
	   SRV(server)->keepalive = ((yyvsp[0].number) == 0) ? false : true;
}
    break;

  case 91:

    {
	   SRV(server)->keepalive_max = (yyvsp[0].number);
}
    break;

  case 92:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 PRINT_MSG ("ERROR: \"SSLCertificateFile\" overlaps: '%s' <- '%s'\n", vsrv->server_cert, (yyvsp[0].string));
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = (yyvsp[0].string);

#else
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateFile\"\n");
#endif
}
    break;

  case 93:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 PRINT_MSG ("ERROR: \"SSLCertificateKeyFile\" overlaps: '%s' <- '%s'\n", vsrv->server_key, (yyvsp[0].string));
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = (yyvsp[0].string);

#else
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateKeyFile\"\n");
#endif
}
    break;

  case 94:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->ca_cert != NULL) {
			 PRINT_MSG ("ERROR: \"SSLCAListFile\" overlaps: '%s' <- '%s'\n", vsrv->ca_cert, (yyvsp[0].string));
			 free (vsrv->ca_cert);
	   }

	   vsrv->ca_cert = (yyvsp[0].string);

#else
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"SSLCAListFile\"\n");
#endif
}
    break;

  case 95:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[0].string));
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Can't load encoder module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }

	   cherokee_module_loader_get_info  (&SRV(server)->loader, (yyvsp[0].string), &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, (yyvsp[0].string), enc);
	   current_encoder_entry = enc;
}
    break;

  case 96:

    {
	   current_encoder_entry = NULL;
}
    break;

  case 99:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = (yyvsp[0].list);
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 100:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = (yyvsp[0].list);
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 101:

    {
	   FILE *file;
	   CHEROKEE_TEMP(buffer, 10);

	   file = fopen ((yyvsp[0].string), "w");
	   if (file == NULL) {
			 PRINT_MSG ("ERROR: Can't write PID file '%s': %s\n", (yyvsp[0].string), strerror(errno));
			 return 0;
	   }

	   snprintf (buffer, buffer_size, "%d\n", getpid());
	   fwrite (buffer, 1, strlen(buffer), file);
	   fclose (file);

	   free ((yyvsp[0].string));
}
    break;

  case 102:

    {
	   cherokee_list_add_tail (&SRV(server)->include_list, (yyvsp[0].string));
}
    break;

  case 103:

    {
	   if (SRV(server)->panic_action != NULL) {
			 PRINT_MSG ("WARNING: Overwriting panic action '%s' by '%s'\n", SRV(server)->panic_action, (yyvsp[0].string));
			 free (SRV(server)->panic_action);
	   }

	   SRV(server)->panic_action = (yyvsp[0].string);
}
    break;

  case 104:

    {
	   SRV(server)->listen_queue = (yyvsp[0].number);
}
    break;

  case 106:

    {
	   SRV(server)->sendfile.min = (yyvsp[0].number);
}
    break;

  case 107:

    {
	   SRV(server)->sendfile.max = (yyvsp[0].number);
}
    break;

  case 108:

    {
	   SRV(server)->max_fds = (yyvsp[0].number);
}
    break;

  case 109:

    {
	   SRV(server)->max_conn_reuse = (yyvsp[0].number);
}
    break;

  case 110:

    {
	   SRV(server)->chroot = (yyvsp[0].string);
}
    break;

  case 111:

    {
#ifdef HAVE_PTHREAD
	   SRV(server)->thread_num = (yyvsp[-1].number);
#endif
}
    break;

  case 114:

    {
#ifdef HAVE_PTHREAD
	   if (strcasecmp((yyvsp[0].string), "fifo") == 0) {
			 SRV(server)->thread_policy = SCHED_FIFO;
	   } else if (strcasecmp((yyvsp[0].string), "rr") == 0) {
			 SRV(server)->thread_policy = SCHED_RR;
	   } else if (strcasecmp((yyvsp[0].string), "other") == 0) {
			 SRV(server)->thread_policy = SCHED_OTHER;
	   } else {
			 PRINT_MSG ("ERROR: unknown scheduling policy '%s'\n", (yyvsp[0].string));
	   }
#endif
}
    break;

  case 115:

    {
	   SRV(server)->ipv6 = (yyvsp[0].number);
}
    break;

  case 116:

    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam ((yyvsp[0].string));
	   if (pwd == NULL) {
			 PRINT_MSG ("ERROR: User '%s' not found in the system", (yyvsp[0].string));
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free ((yyvsp[0].string));
}
    break;

  case 117:

    {
	   SRV(server)->user = (yyvsp[0].number);
}
    break;

  case 118:

    {
	   struct group *grp;

	   grp = (struct group *) getgrnam ((yyvsp[0].string));
	   if (grp == NULL) {
			 PRINT_MSG ("ERROR: Group '%s' not found in the system", (yyvsp[0].string));
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free ((yyvsp[0].string));
}
    break;

  case 119:

    {
	   SRV(server)->group = (yyvsp[0].number);
}
    break;

  case 120:

    {
	   (yyval.name_ptr).name = (yyvsp[-3].string);
	   (yyval.name_ptr).ptr = current_dirs_table_entry;
}
    break;

  case 121:

    {
	   (yyval.name_ptr).name = (yyvsp[0].string);
	   (yyval.name_ptr).ptr = current_dirs_table_entry;
}
    break;

  case 122:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 123:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 124:

    {
	   handler_redir_add_property (current_dirs_table_entry, (yyvsp[-1].string), (yyvsp[0].string), 1);
}
    break;

  case 125:

    {
	   handler_redir_add_property (current_dirs_table_entry, (yyvsp[-1].string), (yyvsp[0].string), 0);
}
    break;

  case 131:

    { 
	   (yyval.string) = (yyvsp[0].string); 
}
    break;

  case 132:

    {
	   if (!strcasecmp ((yyvsp[-1].string), "bgcolor")) {
			 dirs_table_set_prop (current_dirs_table_entry, "bgcolor", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "background")) {
			 dirs_table_set_prop (current_dirs_table_entry, "background", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "text")) {
			 dirs_table_set_prop (current_dirs_table_entry, "text", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "link")) {
			 dirs_table_set_prop (current_dirs_table_entry, "link", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "vlink")) {
			 dirs_table_set_prop (current_dirs_table_entry, "vlink", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "alink")) {
			 dirs_table_set_prop (current_dirs_table_entry, "alink", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "headerfile")) {
			 dirs_table_set_prop (current_dirs_table_entry, "headerfile", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "interpreter")) {
			 dirs_table_set_prop (current_dirs_table_entry, "interpreter", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "scriptalias")) {
			 dirs_table_set_prop (current_dirs_table_entry, "scriptalias", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "url")) {
			 dirs_table_set_prop (current_dirs_table_entry, "url", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "filedir")) {
			 dirs_table_set_prop (current_dirs_table_entry, "filedir", (yyvsp[0].string));
	   } else {
			 return 1;
	   }
}
    break;

  case 133:

    {
	   cuint_t           new_len;
	   char             *new_str;
	   cherokee_table_t *properties;
	   list_t           *plist       = NULL;
	   list_t            nlist       = LIST_HEAD_INIT(nlist);
	   
	   /* Build the string:
	    * VAR \0 VAL \0
	    */
	   new_len = strlen((yyvsp[-1].string)) + strlen((yyvsp[0].string)) + 2;
	   new_str = malloc (new_len);
	   if (new_str == NULL) return 1;
	   
	   memset (new_str, 0, new_len);
	   memcpy (new_str, (yyvsp[-1].string), strlen((yyvsp[-1].string)));
	   memcpy (new_str + strlen((yyvsp[-1].string)) + 1, (yyvsp[0].string), strlen((yyvsp[0].string)));

	   /* Add it to the list
	    */
	   properties = current_dirs_table_entry->properties;

	   if (properties != NULL) {
			 cherokee_typed_table_get_list (properties, "env", &plist);
	   }

	   if (plist == NULL) {
			 cherokee_list_add (&nlist, new_str);
			 cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "env", typed_list, &nlist, 
										  (cherokee_typed_free_func_t) cherokee_list_free_item_simple);
	   } else {
			 cherokee_list_add_tail (plist, new_str);			 
	   }
}
    break;

  case 134:

    { dirs_table_set_prop (current_dirs_table_entry, "socket", (yyvsp[0].string)); }
    break;

  case 135:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "about", typed_int, INT_TO_POINTER(1), NULL); }
    break;

  case 136:

    { dirs_table_set_prop (current_dirs_table_entry, "server", (yyvsp[0].string)); }
    break;

  case 137:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "cache", typed_int, INT_TO_POINTER((yyvsp[0].number)), NULL); }
    break;

  case 138:

    {
	   char code[4];

	   if (((yyvsp[-1].number) < 100) || ((yyvsp[-1].number) >= http_type_500_max)) {
			 PRINT_MSG ("ERROR: Incorrect HTTP code number %d\n", (yyvsp[-1].number));
			 return 1;
	   }

	   snprintf (code, 4, "%d", (yyvsp[-1].number));
	   dirs_table_set_prop (current_dirs_table_entry, code, (yyvsp[0].string));
}
    break;

  case 139:

    {
	   linked_list_t *i;

	   i = (yyvsp[0].list);
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, i->string, typed_int, INT_TO_POINTER(1), NULL);				    
			 } else {
				    PRINT_MSG ("ERROR: Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list ((yyvsp[0].list), free);
}
    break;

  case 142:

    {
	   (yyval.string) = (yyvsp[0].string);
}
    break;

  case 143:

    {
	   linked_list_t *i = (yyvsp[-1].list);
	   CHEROKEE_NEW(vsrv, virtual_server);

	   current_virtual_server = vsrv;
	   current_dirs_table     = &vsrv->dirs;

	   /* Add the virtual server to the list
	    */
	   list_add ((list_t *)vsrv, &SRV(server)->vservers);

	   /* Add default virtual server name
	    */
	   if (i->string != NULL) {
			 cherokee_buffer_t *name = current_virtual_server->name;

			 if (cherokee_buffer_is_empty (name)) {
				    cherokee_buffer_add_va (name, "%s", i->string);
			 }
	   }

	   /* Add all the alias to the table
	    */
	   while (i != NULL) {
			 cherokee_table_add (SRV(server)->vservers_ref, i->string, vsrv);
			 i = i->next;
	   }
	   free_linked_list ((yyvsp[-1].list), NULL);

}
    break;

  case 144:

    {

	   current_virtual_server = NULL;
	   current_dirs_table  = NULL;
}
    break;

  case 145:

    {
	   /* Fill the tmp struct
	    */
	   extension_content_tmp.exts_list      = (yyvsp[-1].list);
	   extension_content_tmp.vserver        = auto_virtual_server;
	   extension_content_tmp.entry          = dirs_table_entry_new (); /* new! */
	   extension_content_tmp.handler_name   = NULL;
	   extension_content_tmp.document_root  = NULL;

	   /* Extensions table is created under demand
	    */
	   if (extension_content_tmp.vserver->exts == NULL) {
			 ret_t ret;

			 ret = cherokee_exts_table_new (&extension_content_tmp.vserver->exts);
			 if (unlikely (ret != ret_ok)) {
				    PRINT_MSG_S ("ERROR: Couldn't instance a new exts table object\n");
				    return 1;
			 }
	   }
	   extension_content_tmp.exts = extension_content_tmp.vserver->exts;
}
    break;

  case 146:

    {
	   ret_t                   ret;
	   linked_list_t          *i;
	   cherokee_module_info_t *info;

	   /* Does this directory have a handler
	    */
	   if (extension_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (&SRV(server)->loader, extension_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_dirs_table_entry_set_handler (extension_content_tmp.entry, info);	   
	   }

	   /* Add "web_dir -> entry" in the dirs table
	    */
	   i = extension_content_tmp.exts_list;
	   while (i != NULL) {
			 ret = cherokee_exts_table_has (extension_content_tmp.exts, i->string);
			 if (ret != ret_not_found) {
				    PRINT_MSG ("ERROR: Extension '%s' was already set\n", i->string);
				    return 1;
			 }

			 ret = cherokee_exts_table_add (extension_content_tmp.exts,
									  i->string,
									  extension_content_tmp.entry);
			 if (ret != ret_ok) {
				    switch (ret) {
				    case ret_file_not_found:
						  PRINT_MSG ("ERROR: Can't load handler '%s': File not found\n",
								   extension_content_tmp.handler_name);
						  break;
				    default:
						  PRINT_MSG ("ERROR: Can't load handler '%s': Unknown error\n",
								   extension_content_tmp.handler_name);
				    }
			 }

			 i = i->next;
	   }

	   /* Clean
	    */
	   if (extension_content_tmp.document_root != NULL) {
			 free (extension_content_tmp.document_root);
			 extension_content_tmp.document_root = NULL;
	   }

	   extension_content_tmp.vserver       = NULL;
	   extension_content_tmp.exts          = NULL;
	   extension_content_tmp.entry         = NULL;
	   extension_content_tmp.handler_name  = NULL;

	   free_linked_list (extension_content_tmp.exts_list, free);
	   extension_content_tmp.exts_list = NULL;

	   current_dirs_table_entry = NULL;
}
    break;

  case 147:

    {
	   /* Fill the tmp struct
	    */
	   directory_content_tmp.directory_name = (yyvsp[-1].string);
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.dirs           = auto_dirs_table;
	   directory_content_tmp.entry          = dirs_table_entry_new (); /* new! */
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 148:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 if (directory_content_tmp.entry->document_root == NULL)
				    cherokee_buffer_new (&directory_content_tmp.entry->document_root);
			 else 
				    cherokee_buffer_clean (directory_content_tmp.entry->document_root);

			 cherokee_buffer_add_va (directory_content_tmp.entry->document_root, "%s",
								directory_content_tmp.document_root);
	   }

	   /* Does this directory have a handler
	    */
	   if (directory_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (&SRV(server)->loader, directory_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_dirs_table_entry_set_handler (directory_content_tmp.entry, info);	   
	   }
	   
	   /* Add "web_dir -> entry" in the dirs table
	    */
	   ret = cherokee_dirs_table_add (directory_content_tmp.dirs,
							    directory_content_tmp.directory_name,
							    directory_content_tmp.entry);
	   if (ret != ret_ok) {
			 switch (ret) {
			 case ret_file_not_found:
				    PRINT_MSG ("ERROR: Can't load handler '%s': File not found\n",
							directory_content_tmp.handler_name);
				    break;
			 default:
				    PRINT_MSG ("ERROR: Can't load handler '%s': Unknown error\n",
							directory_content_tmp.handler_name);
			 }
	   }

	   cherokee_dirs_table_relink (directory_content_tmp.dirs);

	   /* Clean
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.dirs          = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_dirs_table_entry = NULL;
}
    break;

  case 149:

    {	   
	   directory_content_tmp.handler_name = (yyvsp[0].name_ptr).name;
	   extension_content_tmp.handler_name = (yyvsp[0].name_ptr).name;
}
    break;

  case 150:

    {
	   if (directory_content_tmp.document_root != NULL) {
			 PRINT_MSG ("WARNING: Overwriting DocumentRoot '%s' by '%s'\n",
					  directory_content_tmp.document_root, (yyvsp[0].string));

			 free (directory_content_tmp.document_root);
	   }

	   directory_content_tmp.document_root = make_slash_end ((yyvsp[0].string));
}
    break;

  case 151:

    {
	   linked_list_t                  *i     = (yyvsp[-3].list);
	   cherokee_dirs_table_entry_t *entry = directory_content_tmp.entry;

	   while (i != NULL) {
			 if (strncasecmp(i->string, "basic", 5) == 0) {
				    entry->authentication |= http_auth_basic;
			 } 
			 else if (strncasecmp(i->string, "digest", 6) == 0) {
				    entry->authentication |= http_auth_digest;			 
			 }
			 else {
				    PRINT_MSG ("ERROR: Unknown authentication type '%s'\n", i->string);
				    return 1;
			 }

			 i = i->next;
	   }

	   free_linked_list ((yyvsp[-3].list), free);
}
    break;

  case 152:

    {
	   ret_t ret;
	   linked_list_t *i, *prev;
	   CHEROKEE_NEW(n, access);

	   i = (yyvsp[0].list);
	   while (i != NULL) {
			 ret = cherokee_access_add (n, i->string);
			 if (ret != ret_ok) return 1;

			 free (i->string);
			 prev = i;
			 i = i->next;
			 free (prev);
	   }
	   directory_content_tmp.entry->access = n;
}
    break;

  case 153:

    {
#ifndef HAVE_TLS
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"OnlySecure\"\n");
#endif

	   directory_content_tmp.entry->only_secure = true;
}
    break;

  case 154:

    {
	   cherokee_buffer_t *realm;

	   if (directory_content_tmp.entry->auth_realm == NULL) 
			 cherokee_buffer_new (&directory_content_tmp.entry->auth_realm);

	   realm = directory_content_tmp.entry->auth_realm;

	   cherokee_buffer_add (realm, (yyvsp[0].string), strlen((yyvsp[0].string)));
	   free ((yyvsp[0].string));
}
    break;

  case 155:

    {
	   linked_list_t *i;

	   if (directory_content_tmp.entry->users == NULL) {
			 cherokee_table_new (&directory_content_tmp.entry->users);
	   }

	   i = (yyvsp[0].list);
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_table_add (directory_content_tmp.entry->users, i->string, NULL);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }	   
}
    break;

  case 156:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[-1].string));
	   if (ret != ret_ok) {
			 PRINT_MSG ("ERROR: Can't load validator module '%s'\n", (yyvsp[-1].string));
			 return 1;
	   }

	   cherokee_module_loader_get_info  (&SRV(server)->loader, (yyvsp[-1].string), &info);

	   if (info->type != cherokee_validator) {
			 PRINT_MSG ("ERROR: %s is not a validator module!!\n", (yyvsp[-1].string));
	   }

	   directory_content_tmp.entry->validator_new_func = info->new_func;
}
    break;

  case 161:

    { dirs_table_set_prop (current_dirs_table_entry, "file", (yyvsp[0].string)); }
    break;

  case 162:

    {
	   int   len;
	   char *tmp;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Set the users public directory
	    */
	   if (!cherokee_buffer_is_empty (vsrv->userdir)) {
			 PRINT_MSG ("WARNING: Overwriting userdir '%s'\n", vsrv->userdir->buf);
			 cherokee_buffer_clean (vsrv->userdir);
	   }

	   len = strlen((yyvsp[0].string));
	   tmp = make_finish_with_slash ((yyvsp[0].string), &len);
	   cherokee_buffer_add (vsrv->userdir, tmp, len);

	   /* Set the plugin table reference
	    */
	   current_dirs_table = vsrv->userdir_dirs;

}
    break;

  case 163:

    {

	   /* Remove the references
	    */
	   current_dirs_table = NULL;
}
    break;

  case 164:

    {
	   linked_list_t             *i    = (yyvsp[0].list);
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   while (i != NULL) {
			 cherokee_list_add_tail (&vsrv->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list ((yyvsp[0].list), NULL);
}
    break;

  case 167:

    {
	   ret_t                      ret;
	   cherokee_module_info_t    *info;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[0].string));
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Loading module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }

	   ret = cherokee_module_loader_get_info (&SRV(server)->loader, (yyvsp[0].string), &info);
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Loading module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }
	   
	   /* Remove the old (by default) error handler and cretate a new one
	    */
	   vsrv->error_handler = dirs_table_entry_new();

	   /* Setup the loaded module
	    */
	   cherokee_dirs_table_entry_set_handler (vsrv->error_handler, info);
}
    break;


    }

/* Line 1037 of yacc.c.  */


  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {

		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct ("Error: popping",
                             yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct ("Error: discarding lookahead",
              yytoken, &yylval);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}






