/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "read_config_embedded.h"

#include "module.h"
#include "dirs_table.h"
#include "server-protected.h"
#include "virtual_server.h"

ret_t
cherokee_embedded_read_config (cherokee_server_t *srv)
{
	   ret_t                        ret;
	   cherokee_module_info_t      *info;
	   cherokee_dirs_table_entry_t *entry;
	   cherokee_virtual_server_t   *vserver;

	   vserver = srv->vserver_default;

	   /* Add root directory
	    */
	   cherokee_module_loader_load (&srv->loader, "common");
	   cherokee_module_loader_get_info (&srv->loader, "common", &info);
	   
	   cherokee_dirs_table_entry_new (&entry);
	   cherokee_dirs_table_entry_set_handler (entry, info);
	   cherokee_dirs_table_add (&vserver->dirs, "/", entry);
	   cherokee_dirs_table_relink (&vserver->dirs);

	   
	   return ret_ok;
}
