/* A Bison parser, made by GNU Bison 1.875d.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_HANDLER = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_POLICY = 274,
     T_SERVER = 275,
     T_USERDIR = 276,
     T_URL = 277,
     T_PIDFILE = 278,
     T_LISTEN = 279,
     T_FILEDIR = 280,
     T_SERVER_TOKENS = 281,
     T_ENCODER = 282,
     T_ALLOW = 283,
     T_IO_CACHE = 284,
     T_BGCOLOR = 285,
     T_TEXT = 286,
     T_LINK = 287,
     T_ALINK = 288,
     T_VLINK = 289,
     T_BACKGROUND = 290,
     T_DIRECTORYINDEX = 291,
     T_IPV6 = 292,
     T_SHOW = 293,
     T_CHROOT = 294,
     T_HEADER_FILE = 295,
     T_ICONS = 296,
     T_AUTH = 297,
     T_NAME = 298,
     T_METHOD = 299,
     T_PASSWDFILE = 300,
     T_SSL_CA_LIST_FILE = 301,
     T_FROM = 302,
     T_SOCKET = 303,
     T_LOG_FLUSH_INTERVAL = 304,
     T_INCLUDE = 305,
     T_PANIC_ACTION = 306,
     T_JUST_ABOUT = 307,
     T_LISTEN_QUEUE_SIZE = 308,
     T_SENDFILE = 309,
     T_MINSIZE = 310,
     T_MAXSIZE = 311,
     T_MAX_FDS = 312,
     T_INTERPRETER = 313,
     T_SCRIPT_ALIAS = 314,
     T_ONLY_SECURE = 315,
     T_MAX_CONNECTION_REUSE = 316,
     T_REWRITE = 317,
     T_POLL_METHOD = 318,
     T_EXTENSION = 319,
     T_NUMBER = 320,
     T_PORT = 321,
     T_QSTRING = 322,
     T_FULLDIR = 323,
     T_ID = 324,
     T_HTTP_URL = 325,
     T_HTTPS_URL = 326,
     T_HOSTNAME = 327,
     T_IP = 328,
     T_DOMAIN_NAME = 329,
     T_ADDRESS_PORT = 330
   };
#endif
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_HANDLER 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_POLICY 274
#define T_SERVER 275
#define T_USERDIR 276
#define T_URL 277
#define T_PIDFILE 278
#define T_LISTEN 279
#define T_FILEDIR 280
#define T_SERVER_TOKENS 281
#define T_ENCODER 282
#define T_ALLOW 283
#define T_IO_CACHE 284
#define T_BGCOLOR 285
#define T_TEXT 286
#define T_LINK 287
#define T_ALINK 288
#define T_VLINK 289
#define T_BACKGROUND 290
#define T_DIRECTORYINDEX 291
#define T_IPV6 292
#define T_SHOW 293
#define T_CHROOT 294
#define T_HEADER_FILE 295
#define T_ICONS 296
#define T_AUTH 297
#define T_NAME 298
#define T_METHOD 299
#define T_PASSWDFILE 300
#define T_SSL_CA_LIST_FILE 301
#define T_FROM 302
#define T_SOCKET 303
#define T_LOG_FLUSH_INTERVAL 304
#define T_INCLUDE 305
#define T_PANIC_ACTION 306
#define T_JUST_ABOUT 307
#define T_LISTEN_QUEUE_SIZE 308
#define T_SENDFILE 309
#define T_MINSIZE 310
#define T_MAXSIZE 311
#define T_MAX_FDS 312
#define T_INTERPRETER 313
#define T_SCRIPT_ALIAS 314
#define T_ONLY_SECURE 315
#define T_MAX_CONNECTION_REUSE 316
#define T_REWRITE 317
#define T_POLL_METHOD 318
#define T_EXTENSION 319
#define T_NUMBER 320
#define T_PORT 321
#define T_QSTRING 322
#define T_FULLDIR 323
#define T_ID 324
#define T_HTTP_URL 325
#define T_HTTPS_URL 326
#define T_HOSTNAME 327
#define T_IP 328
#define T_DOMAIN_NAME 329
#define T_ADDRESS_PORT 330




/* Copy the first part of user declarations.  */


/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"

#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#include "table.h"
#include "mime.h"
#include "server.h"
#include "server-protected.h"
#include "virtual_server.h"
#include "dirs_table_entry.h"
#include "encoder.h"
#include "logger_table.h"
#include "access.h"
#include "list_ext.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)

typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *list;
} YYSTYPE;
/* Line 191 of yacc.c.  */

# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* What is the right way to import this prototipe?
 */
extern int yylex (void);


extern char *yytext;
extern int   yylineno;

char                                   *current_yacc_file           = NULL;
static cherokee_dirs_table_t           *current_dirs_table          = NULL;
static cherokee_dirs_table_entry_t     *current_dirs_table_entry    = NULL;
static cherokee_virtual_server_t       *current_virtual_server      = NULL;
static cherokee_encoder_table_entry_t  *current_encoder_entry       = NULL;
static cherokee_module_info_t          *current_module_info         = NULL;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;

struct {
	   char                           *handler_name;
	   cherokee_dirs_table_entry_t    *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_dirs_table_t          *dirs;
	   char                           *document_root;
	   char                           *directory_name;
} directory_content_tmp;

struct {
	   char                           *handler_name;
	   cherokee_dirs_table_entry_t    *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_exts_table_t          *exts;
	   char                           *document_root;
	   linked_list_t                  *exts_list;
} extension_content_tmp;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)
#define auto_dirs_table     ((current_dirs_table) ? current_dirs_table : &(auto_virtual_server)->dirs)


static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new;
	   int   new_len;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new_len = (*len) + 2;
	   new  = (char*) malloc (new_len);

	   *len = snprintf (new, new_len, "%s/", string);

	   free (string);
	   return new;
}

static char *
make_slash_end (char *string)
{
	   int len = strlen(string);
	   return make_finish_with_slash (string, &len);
}

static cherokee_dirs_table_entry_t *
dirs_table_entry_new (void)
{
	   cherokee_dirs_table_entry_t *entry;

	   cherokee_dirs_table_entry_new (&entry);
	   current_dirs_table_entry = entry;

	   return entry;
}

static char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}

static int
load_module (cherokee_module_loader_t *loader, char *name, cherokee_module_info_t **info)
{
	   ret_t ret;

	   ret = cherokee_module_loader_load (loader, name);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }
	   
	   ret = cherokee_module_loader_get_info (loader, name, info);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }

	   return 0;
}


static void
handler_redir_add_property (cherokee_dirs_table_entry_t *entry, char *regex, char *subs, int show)
{
	   char  name[32];
	   int  *count = NULL;
	   int   regex_len;
	   int   subs_len;
	   char *serialized;
	   char *p;

	   /* Update the counter
	    */
	   if (entry->properties != NULL)
			 count = (int *)cherokee_table_get_val (entry->properties, "regex_count");
	   
	   if (count == NULL) {
			 count = (int*)malloc(sizeof(int));
			 *count = 1;
			 cherokee_dirs_table_entry_set_prop (entry, "regex_count", (void *)count);
	   } else {
			 (*count)++;
	   }
	   
	   /* Build the string:
	    * [1]show [s]regex \0 [s]subs \0
	    */
	   regex_len = strlen(regex);
	   subs_len = strlen(subs);

	   serialized = (char *) malloc (1 + regex_len + 1 + subs_len + 1);
	   memset (serialized, 0, regex_len + subs_len + 3);

	   p = serialized;

	   *p = show;
	   p++;

	   strncpy (p, regex, regex_len);
	   p += regex_len + 1;
	   
	   strncpy (p, subs, subs_len);

	   snprintf (name, sizeof(name), "regex_%d", *count - 1);
	   cherokee_dirs_table_entry_set_prop (entry, name, serialized);
}


void
yyerror (char* msg)
{
	   char *config;

	   config = (current_yacc_file) ? current_yacc_file : "";

        PRINT_ERROR ("Error parsing file %s:%d '%s', symbol '%s'\n", 
				 config, yylineno, msg, yytext);
}



/* Line 214 of yacc.c.  */


#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  120
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   270

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  79
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  81
/* YYNRULES -- Number of rules. */
#define YYNRULES  170
/* YYNRULES -- Number of states. */
#define YYNSTATES  263

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   330

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    76,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    77,     2,    78,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    93,    96,    97,
     100,   101,   104,   105,   108,   109,   112,   113,   116,   117,
     120,   122,   124,   126,   130,   132,   136,   138,   142,   144,
     146,   148,   152,   155,   158,   161,   164,   167,   168,   173,
     174,   178,   179,   182,   185,   188,   191,   194,   197,   200,
     203,   206,   209,   212,   213,   218,   222,   223,   226,   229,
     232,   235,   238,   241,   246,   249,   252,   255,   258,   261,
     265,   269,   270,   273,   276,   279,   282,   285,   288,   294,
     297,   299,   301,   304,   309,   313,   316,   319,   322,   325,
     328,   331,   334,   337,   340,   343,   345,   348,   351,   354,
     357,   360,   363,   365,   367,   369,   370,   377,   378,   385,
     386,   393,   395,   398,   404,   408,   410,   413,   416,   420,
     424,   425,   426,   429,   432,   433,   440,   443,   444,   448,
     449
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
      80,     0,    -1,    -1,    81,    -1,    83,    -1,    81,    83,
      -1,    85,    -1,    82,    85,    -1,    85,    -1,    84,    -1,
     143,    -1,    99,    -1,   100,    -1,   109,    -1,   110,    -1,
     111,    -1,   112,    -1,   113,    -1,   114,    -1,   122,    -1,
     135,    -1,   136,    -1,   137,    -1,   138,    -1,   130,    -1,
     131,    -1,   134,    -1,   101,    -1,   102,    -1,   123,    -1,
     124,    -1,   125,    -1,   126,    -1,   128,    -1,   129,    -1,
     147,    -1,   145,    -1,   158,    -1,   103,    -1,   156,    -1,
     104,    -1,   118,    -1,   115,    -1,   116,    -1,   117,    -1,
     154,    -1,    -1,    86,   149,    -1,    -1,    87,   127,    -1,
      -1,    88,   141,    -1,    -1,    89,   121,    -1,    -1,    90,
     133,    -1,    -1,    91,   150,    -1,    -1,    92,   147,    -1,
      69,    -1,    68,    -1,    93,    -1,    93,    76,    94,    -1,
      69,    -1,    69,    76,    95,    -1,   142,    -1,   142,    76,
      96,    -1,    73,    -1,    69,    -1,    97,    -1,    97,    76,
      98,    -1,    66,    65,    -1,    24,   142,    -1,    49,    65,
      -1,    63,    69,    -1,    12,    68,    -1,    -1,    13,    69,
     105,   106,    -1,    -1,    77,   107,    78,    -1,    -1,   107,
     108,    -1,    69,    68,    -1,    26,    69,    -1,    14,    68,
      -1,    41,    68,    -1,    10,    65,    -1,    11,    65,    -1,
       8,    65,    -1,     7,    68,    -1,     6,    68,    -1,    46,
      68,    -1,    -1,    27,    69,   119,   120,    -1,    77,    89,
      78,    -1,    -1,    28,    95,    -1,     4,    95,    -1,    23,
      68,    -1,    50,    68,    -1,    51,    68,    -1,    53,    65,
      -1,    54,    77,    87,    78,    -1,    55,    65,    -1,    56,
      65,    -1,    57,    65,    -1,    61,    65,    -1,    39,    68,
      -1,     5,    65,   132,    -1,    77,    90,    78,    -1,    -1,
      19,    69,    -1,    37,    65,    -1,    17,    69,    -1,    17,
      65,    -1,    18,    69,    -1,    18,    65,    -1,    16,    69,
      77,    88,    78,    -1,    16,    69,    -1,    70,    -1,    71,
      -1,    22,   140,    -1,    38,    62,    67,    67,    -1,    62,
      67,    67,    -1,    22,    68,    -1,    25,    68,    -1,    30,
      69,    -1,    31,    69,    -1,    32,    69,    -1,    34,    69,
      -1,    33,    69,    -1,    40,    69,    -1,    48,    68,    -1,
      58,    68,    -1,    52,    -1,    59,    68,    -1,    20,    75,
      -1,    58,    67,    -1,    29,    65,    -1,    65,   140,    -1,
      38,    95,    -1,    69,    -1,    73,    -1,    74,    -1,    -1,
      20,    96,    77,   144,    82,    78,    -1,    -1,    64,    95,
      77,   146,    86,    78,    -1,    -1,    15,    68,    77,   148,
      86,    78,    -1,   139,    -1,    12,    68,    -1,    42,    95,
      77,    91,    78,    -1,    28,    47,    98,    -1,    60,    -1,
      43,    67,    -1,    17,    95,    -1,    44,    69,   151,    -1,
      77,   152,    78,    -1,    -1,    -1,   152,   153,    -1,    45,
      68,    -1,    -1,    21,    69,   155,    77,    92,    78,    -1,
      36,    94,    -1,    -1,    77,    88,    78,    -1,    -1,     9,
      69,   159,   157,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   286,   286,   287,   290,   291,   294,   295,   298,   299,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   342,   343,   345,   346,
     348,   349,   351,   352,   354,   355,   357,   358,   360,   361,
     366,   367,   369,   378,   390,   399,   411,   420,   432,   432,
     434,   443,   452,   457,   462,   467,   485,   507,   506,   532,
     533,   535,   536,   539,   552,   570,   575,   580,   588,   593,
     598,   615,   632,   651,   650,   681,   682,   684,   705,   726,
     745,   750,   760,   765,   767,   772,   777,   782,   787,   792,
     799,   800,   802,   818,   823,   838,   843,   858,   863,   869,
     875,   876,   878,   883,   888,   893,   898,   903,   906,   909,
     912,   915,   918,   921,   924,   927,   930,   933,   936,   939,
     946,   959,   988,   989,   990,   996,   995,  1033,  1032,  1119,
    1118,  1190,  1197,  1210,  1234,  1253,  1263,  1276,  1297,  1317,
    1318,  1321,  1322,  1325,  1331,  1330,  1359,  1373,  1374,  1377,
    1376
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM",
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS",
  "T_ERROR_HANDLER", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT",
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP",
  "T_POLICY", "T_SERVER", "T_USERDIR", "T_URL", "T_PIDFILE", "T_LISTEN",
  "T_FILEDIR", "T_SERVER_TOKENS", "T_ENCODER", "T_ALLOW", "T_IO_CACHE",
  "T_BGCOLOR", "T_TEXT", "T_LINK", "T_ALINK", "T_VLINK", "T_BACKGROUND",
  "T_DIRECTORYINDEX", "T_IPV6", "T_SHOW", "T_CHROOT", "T_HEADER_FILE",
  "T_ICONS", "T_AUTH", "T_NAME", "T_METHOD", "T_PASSWDFILE",
  "T_SSL_CA_LIST_FILE", "T_FROM", "T_SOCKET", "T_LOG_FLUSH_INTERVAL",
  "T_INCLUDE", "T_PANIC_ACTION", "T_JUST_ABOUT", "T_LISTEN_QUEUE_SIZE",
  "T_SENDFILE", "T_MINSIZE", "T_MAXSIZE", "T_MAX_FDS", "T_INTERPRETER",
  "T_SCRIPT_ALIAS", "T_ONLY_SECURE", "T_MAX_CONNECTION_REUSE", "T_REWRITE",
  "T_POLL_METHOD", "T_EXTENSION", "T_NUMBER", "T_PORT", "T_QSTRING",
  "T_FULLDIR", "T_ID", "T_HTTP_URL", "T_HTTPS_URL", "T_HOSTNAME", "T_IP",
  "T_DOMAIN_NAME", "T_ADDRESS_PORT", "','", "'{'", "'}'", "$accept",
  "conffile", "lines", "server_lines", "line", "common_line",
  "server_line", "directory_options", "sendfile_options",
  "handler_options", "encoder_options", "thread_options", "auth_options",
  "directories", "id_or_path", "id_path_list", "id_list", "domain_list",
  "ip_or_domain", "ip_list", "port", "listen", "log_flush_interval",
  "poll_method", "document_root", "log", "@1", "log_optional",
  "tuple_list", "tuple", "server_tokens", "mime", "icons", "timeout",
  "keepalive", "keepalive_max_requests", "ssl_file", "ssl_key_file",
  "ssl_ca_list_file", "encoder", "@2", "maybe_encoder_options",
  "encoder_option", "pidfile", "include", "panic_action",
  "listen_queue_size", "sendfile", "sendfile_option", "maxfds",
  "maxconnectionreuse", "chroot", "thread_number", "maybe_thread_options",
  "thread_option", "ipv6", "user1", "user2", "group1", "group2", "handler",
  "http_generic", "handler_option", "host_name", "server", "@3",
  "extension", "@4", "directory", "@5", "directory_option", "auth_option",
  "maybe_auth_option_params", "auth_option_params", "auth_option_param",
  "userdir", "@6", "directoryindex", "maybe_handlererror_options",
  "errorhandler", "@7", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,    44,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    79,    80,    80,    81,    81,    82,    82,    83,    83,
      84,    84,    84,    84,    84,    84,    84,    84,    84,    84,
      84,    84,    84,    84,    84,    84,    84,    84,    84,    84,
      84,    84,    84,    84,    84,    85,    85,    85,    85,    85,
      85,    85,    85,    85,    85,    85,    86,    86,    87,    87,
      88,    88,    89,    89,    90,    90,    91,    91,    92,    92,
      93,    93,    94,    94,    95,    95,    96,    96,    97,    97,
      98,    98,    99,   100,   101,   102,   103,   105,   104,   106,
     106,   107,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   119,   118,   120,   120,   121,   121,   122,
     123,   124,   125,   126,   127,   127,   128,   129,   130,   131,
     132,   132,   133,   134,   135,   136,   137,   138,   139,   139,
     140,   140,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   142,   142,   142,   144,   143,   146,   145,   148,
     147,   149,   149,   149,   149,   149,   150,   150,   150,   151,
     151,   152,   152,   153,   155,   154,   156,   157,   157,   159,
     158
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     0,     2,
       0,     2,     0,     2,     0,     2,     0,     2,     0,     2,
       1,     1,     1,     3,     1,     3,     1,     3,     1,     1,
       1,     3,     2,     2,     2,     2,     2,     0,     4,     0,
       3,     0,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     4,     3,     0,     2,     2,     2,
       2,     2,     2,     4,     2,     2,     2,     2,     2,     3,
       3,     0,     2,     2,     2,     2,     2,     2,     5,     2,
       1,     1,     2,     4,     3,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     2,     2,     2,     2,
       2,     2,     1,     1,     1,     0,     6,     0,     6,     0,
       6,     1,     2,     5,     3,     1,     2,     2,     3,     3,
       0,     0,     2,     2,     0,     6,     2,     0,     3,     0,
       4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     3,     4,     9,     8,
      11,    12,    27,    28,    38,    40,    13,    14,    15,    16,
      17,    18,    42,    43,    44,    41,    19,    29,    30,    31,
      32,    33,    34,    24,    25,    26,    20,    21,    22,    23,
      10,    36,    35,    45,    39,    37,   111,    91,    90,    89,
     169,    87,    88,    76,    77,    85,     0,   115,   114,   117,
     116,   142,   143,   144,     0,    66,   164,    99,    73,    84,
      93,    61,    60,    62,   166,   113,   108,    86,    92,    74,
     100,   101,   102,    48,   106,   107,    75,    64,     0,    72,
       1,     5,    54,   109,   167,    79,   149,   145,     0,     0,
      96,     0,     0,     0,   147,     0,    50,   170,    81,    78,
      46,     0,    67,    58,    52,    94,    63,     0,     0,   103,
      49,    65,    46,     0,   110,    55,     0,     0,     0,     0,
       6,     0,     0,   104,   105,     0,   112,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,   168,    51,     0,    80,    82,     0,
       0,     0,     0,   155,   150,   151,    47,   146,     7,   165,
      59,     0,     0,    95,    53,   148,   137,   125,   120,   121,
     122,   126,   139,   127,   128,   129,   131,   130,     0,   141,
     132,   133,   138,   134,   136,     0,   140,    83,   152,   119,
       0,     0,    98,    97,     0,   124,    50,    69,    68,    70,
     154,    56,   123,     0,     0,     0,   118,    71,     0,     0,
       0,   153,    57,   157,   156,   160,   161,   158,     0,     0,
     159,   162,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    35,    36,   159,    37,    38,    39,   158,   132,   156,
     162,   135,   245,   161,   103,   104,   118,    94,   239,   240,
      40,    41,    42,    43,    44,    45,   125,   139,   157,   188,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
     130,   145,   204,    56,    57,    58,    59,    60,   150,    61,
      62,    63,    64,   123,   155,    65,    66,    67,    68,    69,
     195,   210,   185,    95,    70,   141,    71,   152,    72,   140,
     196,   252,   257,   258,   261,    73,   129,    74,   137,    75,
     124
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -134
static const short int yypact[] =
{
      77,   -36,   -23,     3,   -25,   -19,     0,     5,     8,    -8,
       9,    10,   -28,   -18,   -53,    12,    11,   -53,    24,    27,
     -34,    34,    37,    38,    39,    43,    41,    42,    46,    25,
      47,    52,    50,    51,    56,   122,    77,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,    48,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,    55,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,    58,    53,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,    57,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,    60,    67,  -134,
    -134,  -134,  -134,  -134,    68,    75,  -134,  -134,   -53,    76,
      79,   -34,   -29,    51,  -134,   -12,  -134,  -134,  -134,  -134,
    -134,   206,  -134,  -134,  -134,  -134,  -134,    59,    89,  -134,
    -134,  -134,  -134,    90,  -134,  -134,   117,   -50,    -6,    -4,
    -134,   -11,    -3,  -134,  -134,     2,  -134,    83,   -15,    92,
      96,    93,    94,    95,    97,    98,   -38,    99,   102,  -134,
     -10,   103,   105,    -7,  -134,  -134,   106,  -134,  -134,   109,
     104,   134,    51,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,    51,    51,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,   118,  -134,
    -134,  -134,  -134,  -134,  -134,   119,  -134,  -134,  -134,   107,
     -21,   116,  -134,  -134,   127,  -134,  -134,  -134,  -134,   121,
    -134,  -134,  -134,   158,   -21,    -5,  -134,  -134,    51,   132,
     131,  -134,  -134,  -134,  -134,   124,  -134,  -134,   -32,   135,
    -134,  -134,  -134
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -134,  -134,  -134,  -134,   166,  -134,  -126,    62,  -134,   -31,
    -134,  -134,  -134,  -134,  -134,    73,  -133,    80,  -134,   -37,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134,    26,  -134,   194,  -134,  -134,  -134,  -134,    61,  -134,
    -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
    -134
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned short int yytable[] =
{
     151,   201,     2,     3,    11,     5,   189,   153,     8,     9,
     190,    11,   248,   259,   189,   160,    91,    15,   190,   186,
      92,    93,   191,    19,   218,   202,   147,   148,   187,    76,
     191,   117,    20,   198,   101,   102,   192,    87,   249,   250,
      79,    88,    24,   219,   192,    77,   260,    89,   237,   149,
      80,    90,   238,   207,   193,   208,   209,   222,   223,   231,
      33,    84,   193,   208,   209,    81,   154,   199,   232,   233,
      82,    78,   194,   251,   197,   203,    83,    85,    86,    97,
     205,    96,     1,     2,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    99,    12,    13,   100,    14,    15,   105,
      16,    17,   113,    18,    19,   106,   107,   108,   109,   110,
     111,   112,   114,    20,    21,   253,    22,   115,    23,   116,
     117,   119,   120,    24,   163,   122,    25,    26,    27,   128,
      28,    29,   126,   131,    30,   127,   133,   167,    31,   168,
      32,    33,   169,    34,   134,   136,   170,   171,   172,   173,
     174,   175,   138,   143,   164,   176,   144,   177,   206,   166,
     211,   212,   213,   214,   215,   178,   216,   217,   220,   179,
     221,   224,   225,   229,   227,   180,   181,   228,   167,   182,
     168,   230,   183,   169,   236,   234,   235,   170,   171,   172,
     173,   174,   175,   241,   242,   184,   176,   244,   177,   254,
     255,   256,   121,   262,   146,   243,   178,   247,   142,   226,
     179,    98,     2,     3,   165,     5,   180,   181,     8,     9,
     182,    11,   200,   183,     0,     0,     0,    15,     0,     0,
       0,     0,     0,    19,     0,     0,   246,     0,     0,     0,
       0,     0,    20,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    24,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33
};

static const short int yycheck[] =
{
     133,     4,     6,     7,    15,     9,    12,    19,    12,    13,
      16,    15,    17,    45,    12,   141,    69,    21,    16,    69,
      73,    74,    28,    27,    62,    28,    55,    56,    78,    65,
      28,    69,    36,   159,    68,    69,    42,    65,    43,    44,
      65,    69,    46,   176,    42,    68,    78,    65,    69,    78,
      69,    69,    73,    68,    60,    70,    71,    67,    68,   192,
      64,    69,    60,    70,    71,    65,    78,    78,   201,   202,
      65,    68,    78,    78,    78,    78,    68,    68,    68,    68,
      78,    69,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    69,    17,    18,    69,    20,    21,    65,
      23,    24,    77,    26,    27,    68,    68,    68,    65,    68,
      68,    65,    65,    36,    37,   248,    39,    65,    41,    69,
      69,    65,     0,    46,    65,    77,    49,    50,    51,    76,
      53,    54,    77,    76,    57,    77,    76,    20,    61,    22,
      63,    64,    25,    66,    77,    77,    29,    30,    31,    32,
      33,    34,    77,    77,    65,    38,    77,    40,    75,    69,
      68,    65,    69,    69,    69,    48,    69,    69,    69,    52,
      68,    68,    67,    69,    68,    58,    59,    68,    20,    62,
      22,    47,    65,    25,    77,    67,    67,    29,    30,    31,
      32,    33,    34,    77,    67,    78,    38,    76,    40,    67,
      69,    77,    36,    68,   131,   236,    48,   244,   128,   183,
      52,    17,     6,     7,   152,     9,    58,    59,    12,    13,
      62,    15,   161,    65,    -1,    -1,    -1,    21,    -1,    -1,
      -1,    -1,    -1,    27,    -1,    -1,    78,    -1,    -1,    -1,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    20,    21,    23,    24,    26,    27,
      36,    37,    39,    41,    46,    49,    50,    51,    53,    54,
      57,    61,    63,    64,    66,    80,    81,    83,    84,    85,
      99,   100,   101,   102,   103,   104,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   122,   123,   124,   125,
     126,   128,   129,   130,   131,   134,   135,   136,   137,   138,
     143,   145,   147,   154,   156,   158,    65,    68,    68,    65,
      69,    65,    65,    68,    69,    68,    68,    65,    69,    65,
      69,    69,    73,    74,    96,   142,    69,    68,   142,    69,
      69,    68,    69,    93,    94,    65,    68,    68,    68,    65,
      68,    68,    65,    77,    65,    65,    69,    69,    95,    65,
       0,    83,    77,   132,   159,   105,    77,    77,    76,   155,
     119,    76,    87,    76,    77,    90,    77,   157,    77,   106,
     148,   144,    96,    77,    77,   120,    94,    55,    56,    78,
     127,    95,   146,    19,    78,   133,    88,   107,    86,    82,
      85,    92,    89,    65,    65,    86,    69,    20,    22,    25,
      29,    30,    31,    32,    33,    34,    38,    40,    48,    52,
      58,    59,    62,    65,    78,   141,    69,    78,   108,    12,
      16,    28,    42,    60,    78,   139,   149,    78,    85,    78,
     147,     4,    28,    78,   121,    78,    75,    68,    70,    71,
     140,    68,    65,    69,    69,    69,    69,    69,    62,    95,
      69,    68,    67,    68,    68,    67,   140,    68,    68,    69,
      47,    95,    95,    95,    67,    67,    77,    69,    73,    97,
      98,    77,    67,    88,    76,    91,    78,    98,    17,    43,
      44,    78,   150,    95,    67,    69,    77,   151,   152,    45,
      78,   153,    68
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 60:

    { yyval.string = yyvsp[0].string; }
    break;

  case 61:

    { yyval.string = yyvsp[0].string; }
    break;

  case 62:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 63:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 64:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 65:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 66:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 67:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 70:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = NULL;
	   n->string = yyvsp[0].string;

	   yyval.list = n;
}
    break;

  case 71:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 72:

    {
	   SRV(server)->port = yyvsp[0].number;
}
    break;

  case 73:

    {
	   SRV(server)->listen_to = yyvsp[0].string;
}
    break;

  case 74:

    {
	   SRV(server)->log_flush_elapse = yyvsp[0].number;
}
    break;

  case 75:

    {
	   if (strcmp(yyvsp[0].string, "epoll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_epoll;
	   } else if (strcmp(yyvsp[0].string, "port") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_port;
	   } else if (strcmp(yyvsp[0].string, "kqueue") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_kqueue;
	   } else if (strcmp(yyvsp[0].string, "poll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_poll;
	   } else if (strcmp(yyvsp[0].string, "select") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_select;
	   } else {
			 PRINT_ERROR ("ERROR: Unknown polling method '%s'\n", yyvsp[0].string);
			 return 1;
	   }
}
    break;

  case 76:

    {
	   char                      *root;
	   int                        root_len;
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;

	   root     = yyvsp[0].string;
	   root_len = strlen(yyvsp[0].string);

	   /* Check for the endding slash
	    */
	   root = make_finish_with_slash (root, &root_len);

	   /* Add the virtual root path to the virtual server struct
	    */
	   cherokee_buffer_add (vserver->root, root, root_len);
}
    break;

  case 77:

    {
	   ret_t ret;

	   /* Maybe load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load logger module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get_info (SRV(server)->loader, yyvsp[0].string, &current_module_info);
}
    break;

  case 78:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, yyvsp[-2].string, current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 83:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_table_add (vserver->logger_props, yyvsp[-1].string, yyvsp[0].string);
}
    break;

  case 84:

    {
	   if (!strncasecmp("Product", yyvsp[0].string, 7)) {
			 SRV(server)->server_token = cherokee_version_product;
	   } else if (!strncasecmp("Minor", yyvsp[0].string, 5)) {
			 SRV(server)->server_token = cherokee_version_minor;
	   } else if (!strncasecmp("Minimal", yyvsp[0].string, 7)) {
			 SRV(server)->server_token = cherokee_version_minimal;
	   } else if (!strncasecmp("OS", yyvsp[0].string, 2)) {
			 SRV(server)->server_token = cherokee_version_os;
	   } else if (!strncasecmp("Full", yyvsp[0].string, 4)) {
			 SRV(server)->server_token = cherokee_version_full;
	   } else {
			 PRINT_ERROR ("ERROR: Unknown server token '%s'\n", yyvsp[0].string);
			 return 1;
	   }
}
    break;

  case 85:

    {
	   SRV(server)->mime_file = yyvsp[0].string;
}
    break;

  case 86:

    {
	   SRV(server)->icons_file = yyvsp[0].string;
}
    break;

  case 87:

    {
	   SRV(server)->timeout = yyvsp[0].number;

	   cherokee_buffer_clean  (SRV(server)->timeout_header);
	   cherokee_buffer_add_va (SRV(server)->timeout_header, "Keep-Alive: timeout=%d"CRLF, yyvsp[0].number);
}
    break;

  case 88:

    {
	   SRV(server)->keepalive = (yyvsp[0].number == 0) ? false : true;
}
    break;

  case 89:

    {
	   SRV(server)->keepalive_max = yyvsp[0].number;
}
    break;

  case 90:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCertificateFile\" overlaps: '%s' <- '%s'\n", vsrv->server_cert, yyvsp[0].string);
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateFile\"\n");
#endif
}
    break;

  case 91:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCertificateKeyFile\" overlaps: '%s' <- '%s'\n", vsrv->server_key, yyvsp[0].string);
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateKeyFile\"\n");
#endif
}
    break;

  case 92:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->ca_cert != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCAListFile\" overlaps: '%s' <- '%s'\n", vsrv->ca_cert, yyvsp[0].string);
			 free (vsrv->ca_cert);
	   }

	   vsrv->ca_cert = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCAListFile\"\n");
#endif
}
    break;

  case 93:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load encoder module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get_info  (SRV(server)->loader, yyvsp[0].string, &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, yyvsp[0].string, enc);
	   current_encoder_entry = enc;
}
    break;

  case 94:

    {
	   current_encoder_entry = NULL;
}
    break;

  case 97:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 98:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 99:

    {
	   FILE *file;
	   CHEROKEE_TEMP(buffer, 10);

	   file = fopen (yyvsp[0].string, "w");
	   if (file == NULL) {
			 PRINT_ERROR ("ERROR: Can't write PID file '%s': %s\n", yyvsp[0].string, strerror(errno));
			 return 0;
	   }

	   snprintf (buffer, buffer_size, "%d\n", getpid());
	   fwrite (buffer, 1, strlen(buffer), file);
	   fclose (file);

	   free (yyvsp[0].string);
}
    break;

  case 100:

    {
	   cherokee_list_add_tail (&SRV(server)->include_list, yyvsp[0].string);
}
    break;

  case 101:

    {
	   if (SRV(server)->panic_action != NULL) {
			 PRINT_ERROR ("WARNING: Overwriting panic action '%s' by '%s'\n", SRV(server)->panic_action, yyvsp[0].string);
			 free (SRV(server)->panic_action);
	   }

	   SRV(server)->panic_action = yyvsp[0].string;
}
    break;

  case 102:

    {
	   SRV(server)->listen_queue = yyvsp[0].number;
}
    break;

  case 104:

    {
	   SRV(server)->sendfile.min = yyvsp[0].number;
}
    break;

  case 105:

    {
	   SRV(server)->sendfile.max = yyvsp[0].number;
}
    break;

  case 106:

    {
	   SRV(server)->max_fds = yyvsp[0].number;
}
    break;

  case 107:

    {
	   SRV(server)->max_conn_reuse = yyvsp[0].number;
}
    break;

  case 108:

    {
	   SRV(server)->chroot = yyvsp[0].string;
}
    break;

  case 109:

    {
#ifdef HAVE_PTHREAD
	   SRV(server)->thread_num = yyvsp[-1].number;
#endif
}
    break;

  case 112:

    {
#ifdef HAVE_PTHREAD
	   if (strcasecmp(yyvsp[0].string, "fifo") == 0) {
			 SRV(server)->thread_policy = SCHED_FIFO;
	   } else if (strcasecmp(yyvsp[0].string, "rr") == 0) {
			 SRV(server)->thread_policy = SCHED_RR;
	   } else if (strcasecmp(yyvsp[0].string, "other") == 0) {
			 SRV(server)->thread_policy = SCHED_OTHER;
	   } else {
			 PRINT_ERROR ("ERROR: unknown scheduling policy '%s'\n", yyvsp[0].string);
	   }
#endif
}
    break;

  case 113:

    {
	   SRV(server)->ipv6 = yyvsp[0].number;
}
    break;

  case 114:

    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam (yyvsp[0].string);
	   if (pwd == NULL) {
			 PRINT_ERROR ("ERROR: User '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free (yyvsp[0].string);
}
    break;

  case 115:

    {
	   SRV(server)->user = yyvsp[0].number;
}
    break;

  case 116:

    {
	   struct group *grp;

	   grp = (struct group *) getgrnam (yyvsp[0].string);
	   if (grp == NULL) {
			 PRINT_ERROR ("ERROR: Group '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free (yyvsp[0].string);
}
    break;

  case 117:

    {
	   SRV(server)->group = yyvsp[0].number;
}
    break;

  case 118:

    {
	   yyval.name_ptr.name = yyvsp[-3].string;
	   yyval.name_ptr.ptr = current_dirs_table_entry;
}
    break;

  case 119:

    {
	   yyval.name_ptr.name = yyvsp[0].string;
	   yyval.name_ptr.ptr = current_dirs_table_entry;
}
    break;

  case 120:

    { yyval.string = yyvsp[0].string; }
    break;

  case 121:

    { yyval.string = yyvsp[0].string; }
    break;

  case 122:

    {
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "url", yyvsp[0].string);
}
    break;

  case 123:

    {
	   handler_redir_add_property (current_dirs_table_entry, yyvsp[-1].string, yyvsp[0].string, 1);
}
    break;

  case 124:

    {
	   handler_redir_add_property (current_dirs_table_entry, yyvsp[-1].string, yyvsp[0].string, 0);
}
    break;

  case 125:

    {
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "url", yyvsp[0].string);
}
    break;

  case 126:

    {
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "filedir", yyvsp[0].string);
}
    break;

  case 127:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "bgcolor", yyvsp[0].string); }
    break;

  case 128:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "text", yyvsp[0].string); }
    break;

  case 129:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "link", yyvsp[0].string); }
    break;

  case 130:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "vlink", yyvsp[0].string); }
    break;

  case 131:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "alink", yyvsp[0].string); }
    break;

  case 132:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "headerfile", yyvsp[0].string); }
    break;

  case 133:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "socket", yyvsp[0].string); }
    break;

  case 134:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "interpreter", yyvsp[0].string); }
    break;

  case 135:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "about", NULL); }
    break;

  case 136:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "scriptalias", yyvsp[0].string); }
    break;

  case 137:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "server", yyvsp[0].string); }
    break;

  case 138:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "interpreter", yyvsp[0].string); }
    break;

  case 139:

    { if (yyvsp[0].number)
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "cache", strdup("on"));
  else 
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "cache", strdup("off"));								    
}
    break;

  case 140:

    {
	   char code[4];

	   if ((yyvsp[-1].number < 100) || (yyvsp[-1].number >= http_type_500_max)) {
			 PRINT_ERROR("ERROR: Incorrect HTTP code number %d\n", yyvsp[-1].number);
			 return 1;
	   }

	   snprintf (code, 4, "%d", yyvsp[-1].number);
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, code, yyvsp[0].string);
}
    break;

  case 141:

    {
	   linked_list_t *i;

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, i->string, i->string);				    
			 } else {
				    PRINT_ERROR ("ERROR: Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, free);
}
    break;

  case 144:

    {
	   yyval.string = yyvsp[0].string;
}
    break;

  case 145:

    {
	   linked_list_t *i = yyvsp[-1].list;
	   CHEROKEE_NEW(vsrv, virtual_server);

	   current_virtual_server = vsrv;
	   current_dirs_table     = &vsrv->dirs;

	   /* Add the virtual server to the list
	    */
	   list_add ((list_t *)vsrv, &SRV(server)->vservers);

	   /* Add default virtual server name
	    */
	   if (i->string != NULL) {
			 cherokee_buffer_t *name = current_virtual_server->name;

			 if (cherokee_buffer_is_empty (name)) {
				    cherokee_buffer_add_va (name, "%s", i->string);
			 }
	   }

	   /* Add all the alias to the table
	    */
	   while (i != NULL) {
			 cherokee_table_add (SRV(server)->vservers_ref, i->string, vsrv);
			 i = i->next;
	   }
	   free_linked_list (yyvsp[-1].list, NULL);

}
    break;

  case 146:

    {

	   current_virtual_server = NULL;
	   current_dirs_table  = NULL;
}
    break;

  case 147:

    {
	   /* Fill the tmp struct
	    */
	   extension_content_tmp.exts_list      = yyvsp[-1].list;
	   extension_content_tmp.vserver        = auto_virtual_server;
	   extension_content_tmp.entry          = dirs_table_entry_new (); /* new! */
	   extension_content_tmp.handler_name   = NULL;
	   extension_content_tmp.document_root  = NULL;

	   /* Extensions table is created under demand
	    */
	   if (extension_content_tmp.vserver->exts == NULL) {
			 ret_t ret;

			 ret = cherokee_exts_table_new (&extension_content_tmp.vserver->exts);
			 if (unlikely (ret != ret_ok)) {
				    PRINT_ERROR_S ("ERROR: Couldn't instance a new exts table object\n");
				    return 1;
			 }
	   }
	   extension_content_tmp.exts = extension_content_tmp.vserver->exts;
}
    break;

  case 148:

    {
	   ret_t                   ret;
	   linked_list_t          *i;
	   cherokee_module_info_t *info;

	   /* Does this directory have a handler
	    */
	   if (extension_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (SRV(server)->loader, extension_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_dirs_table_entry_set_handler (extension_content_tmp.entry, info);	   
	   }

	   /* Add "web_dir -> entry" in the dirs table
	    */
	   i = extension_content_tmp.exts_list;
	   while (i != NULL) {
			 ret = cherokee_exts_table_has (extension_content_tmp.exts, i->string);
			 if (ret != ret_not_found) {
				    PRINT_ERROR ("ERROR: Extension '%s' was already set\n", i->string);
				    return 1;
			 }

			 ret = cherokee_exts_table_add (extension_content_tmp.exts,
									  i->string,
									  extension_content_tmp.entry);
			 if (ret != ret_ok) {
				    switch (ret) {
				    case ret_file_not_found:
						  PRINT_ERROR ("ERROR: Can't load handler '%s': File not found\n",
									extension_content_tmp.handler_name);
						  break;
				    default:
						  PRINT_ERROR ("ERROR: Can't load handler '%s': Unknown error\n",
									extension_content_tmp.handler_name);
				    }
			 }

			 i = i->next;
	   }

	   /* Clean
	    */
	   if (extension_content_tmp.document_root != NULL) {
			 free (extension_content_tmp.document_root);
			 extension_content_tmp.document_root = NULL;
	   }

	   extension_content_tmp.vserver       = NULL;
	   extension_content_tmp.exts          = NULL;
	   extension_content_tmp.entry         = NULL;
	   extension_content_tmp.handler_name  = NULL;

	   free_linked_list (extension_content_tmp.exts_list, free);
	   extension_content_tmp.exts_list = NULL;

	   current_dirs_table_entry = NULL;
}
    break;

  case 149:

    {
	   /* Fill the tmp struct
	    */
	   directory_content_tmp.directory_name = yyvsp[-1].string;
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.dirs           = auto_dirs_table;
	   directory_content_tmp.entry          = dirs_table_entry_new (); /* new! */
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 150:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 if (directory_content_tmp.entry->document_root == NULL)
				    cherokee_buffer_new (&directory_content_tmp.entry->document_root);
			 else 
				    cherokee_buffer_clean (directory_content_tmp.entry->document_root);

			 cherokee_buffer_add_va (directory_content_tmp.entry->document_root, "%s",
								directory_content_tmp.document_root);
	   }

	   /* Does this directory have a handler
	    */
	   if (directory_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (SRV(server)->loader, directory_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_dirs_table_entry_set_handler (directory_content_tmp.entry, info);	   
	   }
	   
	   /* Add "web_dir -> entry" in the dirs table
	    */
	   ret = cherokee_dirs_table_add (directory_content_tmp.dirs,
							    directory_content_tmp.directory_name,
							    directory_content_tmp.entry);
	   if (ret != ret_ok) {
			 switch (ret) {
			 case ret_file_not_found:
				    PRINT_ERROR ("ERROR: Can't load handler '%s': File not found\n",
							  directory_content_tmp.handler_name);
				    break;
			 default:
				    PRINT_ERROR ("ERROR: Can't load handler '%s': Unknown error\n",
							  directory_content_tmp.handler_name);
			 }
	   }

	   cherokee_dirs_table_relink (directory_content_tmp.dirs);

	   /* Clean
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.dirs          = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_dirs_table_entry = NULL;
}
    break;

  case 151:

    {	   
	   directory_content_tmp.handler_name = yyvsp[0].name_ptr.name;
	   extension_content_tmp.handler_name = yyvsp[0].name_ptr.name;
}
    break;

  case 152:

    {
	   if (directory_content_tmp.document_root != NULL) {
			 PRINT_ERROR ("WARNING: Overwriting DocumentRoot '%s' by '%s'\n",
					    directory_content_tmp.document_root, yyvsp[0].string);

			 free (directory_content_tmp.document_root);
	   }

	   directory_content_tmp.document_root = make_slash_end (yyvsp[0].string);
}
    break;

  case 153:

    {
	   linked_list_t                  *i     = yyvsp[-3].list;
	   cherokee_dirs_table_entry_t *entry = directory_content_tmp.entry;

	   while (i != NULL) {
			 if (strncasecmp(i->string, "basic", 5) == 0) {
				    entry->authentication |= http_auth_basic;
			 } 
			 else if (strncasecmp(i->string, "digest", 6) == 0) {
				    entry->authentication |= http_auth_digest;			 
			 }
			 else {
				    PRINT_ERROR ("ERROR: Unknown authentication type '%s'\n", i->string);
				    return 1;
			 }

			 i = i->next;
	   }

	   free_linked_list (yyvsp[-3].list, free);
}
    break;

  case 154:

    {
	   ret_t ret;
	   linked_list_t *i, *prev;
	   CHEROKEE_NEW(n, access);

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 ret = cherokee_access_add (n, i->string);
			 if (ret != ret_ok) return 1;

			 free (i->string);
			 prev = i;
			 i = i->next;
			 free (prev);
	   }
	   directory_content_tmp.entry->access = n;
}
    break;

  case 155:

    {
#ifndef HAVE_TLS
	   PRINT_ERROR_S ("ERROR: Cherokee is compiled without TLS support, so\n"
				   "       it isn't possible to use OnlySecure\n");
#endif

	   directory_content_tmp.entry->only_secure = true;
}
    break;

  case 156:

    {
	   cherokee_buffer_t *realm;

	   if (directory_content_tmp.entry->auth_realm == NULL) 
			 cherokee_buffer_new (&directory_content_tmp.entry->auth_realm);

	   realm = directory_content_tmp.entry->auth_realm;

	   cherokee_buffer_add (realm, yyvsp[0].string, strlen(yyvsp[0].string));
	   free (yyvsp[0].string);
}
    break;

  case 157:

    {
	   linked_list_t *i;

	   if (directory_content_tmp.entry->users == NULL) {
			 cherokee_table_new (&directory_content_tmp.entry->users);
	   }

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_table_add (directory_content_tmp.entry->users, i->string, NULL);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }	   
}
    break;

  case 158:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].string);
	   if (ret != ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load validator module '%s'\n", yyvsp[-1].string);
			 return 1;
	   }

	   cherokee_module_loader_get_info  (SRV(server)->loader, yyvsp[-1].string, &info);

	   if (info->type != cherokee_validator) {
			 PRINT_ERROR ("ERROR: %s is not a validator module!!\n", yyvsp[-1].string);
	   }

	   directory_content_tmp.entry->validator_new_func = info->new_func;
}
    break;

  case 163:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "file", yyvsp[0].string); }
    break;

  case 164:

    {
	   int   len;
	   char *tmp;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Set the users public directory
	    */
	   if (!cherokee_buffer_is_empty (vsrv->userdir)) {
			 PRINT_ERROR ("WARNING: Overwriting userdir '%s'\n", vsrv->userdir->buf);
			 cherokee_buffer_clean (vsrv->userdir);
	   }

	   len = strlen(yyvsp[0].string);
	   tmp = make_finish_with_slash (yyvsp[0].string, &len);
	   cherokee_buffer_add (vsrv->userdir, tmp, len);

	   /* Set the plugin table reference
	    */
	   current_dirs_table = vsrv->userdir_dirs;

}
    break;

  case 165:

    {

	   /* Remove the references
	    */
	   current_dirs_table = NULL;
}
    break;

  case 166:

    {
	   linked_list_t             *i    = yyvsp[0].list;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   while (i != NULL) {
			 cherokee_list_add_tail (&vsrv->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, NULL);
}
    break;

  case 169:

    {
	   ret_t                      ret;
	   cherokee_module_info_t    *info;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   ret = cherokee_module_loader_get_info (SRV(server)->loader, yyvsp[0].string, &info);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", yyvsp[0].string);
			 return 1;
	   }
	   
	   /* Remove the old (by default) error handler and cretate a new one
	    */
	   vsrv->error_handler = dirs_table_entry_new();

	   /* Setup the loaded module
	    */
	   cherokee_dirs_table_entry_set_handler (vsrv->error_handler, info);
}
    break;


    }

/* Line 1010 of yacc.c.  */


  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}






