%{
/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"
#include "list_ext.h"
#include "config_value.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM config

%}

%union {
	   int                      number;
	   char                    *string;
	   struct list_head        *list;
	   void                    *config_value;
}

%{


/* What is the right way to import these prototipes?
 * There's the same problem in read_config_grammar.y
 */
extern int   yy_config_protocol_lex(void);
extern char *yy_config_protocol_text;
extern int   yy_config_protocol_lineno;


void
yy_config_protocol_error(char* msg)
{
        PRINT_ERROR ("ERROR: parsing configuration protocol: '%s', line %d, symbol '%s' (0x%x)\n", 
				 msg, yy_config_protocol_lineno, yy_config_protocol_text, yy_config_protocol_text[0]);
}

%}

%token T_NEWLINE T_NUMBER T_STRING T_LIST T_KEYVAL
%token <string> T_STR
%token <number> T_NUM

%type <config_value> list string number keyval item list_internal

%%

config : list
{
	   *((cherokee_config_value_t **)config) = $1;
};

item : list
     | number
     | string
     | keyval;

list : '(' list_internal ')'
{
	   ret_t                    ret;
	   cherokee_config_value_t *n;
	   
	   ret = cherokee_config_value_new (&n);
	   if (unlikely (ret != ret_ok)) return 1;

	   list_add ((list_t *)$2, &n->list);

	   $$ = n;
};

list_internal : item
{
	   $$ = $1;
};

list_internal : item list_internal
{
	   list_add((list_t *)$1, (list_t *)$2);
	   $$ = $1;
};

number : '(' T_NUMBER ' ' T_NUM ')'
{
	   ret_t                    ret;
	   cherokee_config_value_t *n;
	   
	   ret = cherokee_config_value_new (&n);
	   if (unlikely (ret != ret_ok)) return 1;

	   n->type = cvalue_number;
	   n->number = $4;

	   $$ = n;
};

string : '(' T_STRING ' ' T_STR ')'
{
	   ret_t                    ret;
	   cherokee_config_value_t *n;
	   
	   ret = cherokee_config_value_new (&n);
	   if (unlikely (ret != ret_ok)) return 1;

	   n->type = cvalue_string;
	   cherokee_buffer_add (&n->string, $4+1, strlen($4)-2);
	   free ($4);

	   $$ = n;
};

keyval : '(' string item ')'
{
	   ret_t                    ret;
	   cherokee_config_value_t *n;
	   
	   ret = cherokee_config_value_new (&n);
	   if (unlikely (ret != ret_ok)) return 1;

	   n->type         = cvalue_keyval;
	   n->keyval.value = $3;

	   cherokee_buffer_add_buffer (&n->keyval.key, &CONFVAL($2)->string);
	   cherokee_config_value_free ($2);

	   $$ = n;
};

