/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"
#include "handler_fastcgi.h"
#include "fastcgi.h"
#include "connection.h"
#include "connection-protected.h"
#include "thread.h"


cherokee_module_info_t cherokee_fastcgi_info = {
	cherokee_handler,               /* type     */
	cherokee_handler_fastcgi_new    /* new func */
};


static void
fcgi_header_set (FCGI_Header *hdr, cuchar_t type, cushort_t request_id, cuint_t content_length, cuchar_t padding)
{
	hdr->version         = FCGI_VERSION_1;
	hdr->type            = type;
        hdr->requestIdB0     = request_id & 0xff;
        hdr->requestIdB1     = (request_id >> 8) & 0xff;
        hdr->contentLengthB0 = content_length & 0xff;
        hdr->contentLengthB1 = (content_length >> 8) & 0xff;
	hdr->paddingLength   = padding;
        hdr->reserved        = 0;
}


ret_t 
cherokee_handler_fastcgi_new (cherokee_handler_t **hdl, cherokee_connection_t *cnt, cherokee_table_t *properties)
{
	CHEROKEE_NEW_STRUCT (n, handler_fastcgi);

	/* Init the base class object
	 */
	cherokee_handler_init_base (HANDLER(n), cnt);
	   
	MODULE(n)->init         = (handler_func_init_t) cherokee_handler_fastcgi_init;
	MODULE(n)->free         = (handler_func_free_t) cherokee_handler_fastcgi_free;
	HANDLER(n)->step        = (handler_func_step_t) cherokee_handler_fastcgi_step;
	HANDLER(n)->add_headers = (handler_func_add_headers_t) cherokee_handler_fastcgi_add_headers; 

	/* Supported features
	 */
	HANDLER(n)->support     = hsupport_nothing;

	/* Init
	 */	
	cherokee_buffer_init (&n->write_buffer);
	cherokee_buffer_init (&n->incoming_buffer);
	cherokee_buffer_init (&n->environment);

	if (properties) {
		;
	}

	/* Return
	 */
	*hdl = HANDLER(n);
	return ret_ok;
}


ret_t 
cherokee_handler_fastcgi_free (cherokee_handler_fastcgi_t *hdl)
{
	cherokee_buffer_mrproper (&hdl->write_buffer);
	cherokee_buffer_mrproper (&hdl->incoming_buffer);
	cherokee_buffer_mrproper (&hdl->environment);

	return ret_ok;
}






static void
add_env_pair (cherokee_buffer_t *buf, 
	      char *key, int key_len,
	      char *val, int val_len)
{
	int len;

	len  = key_len + val_len;
        len += key_len > 127 ? 4 : 1;
        len += val_len > 127 ? 4 : 1;

	cherokee_buffer_ensure_size (buf, buf->len + key_len + val_len);

	if (key_len <= 127) {
		buf->buf[buf->len++] = key_len;
	} else {
		buf->buf[buf->len++] = ((key_len >> 24) & 0xff) | 0x80;
		buf->buf[buf->len++] =  (key_len >> 16) & 0xff;
		buf->buf[buf->len++] =  (key_len >> 8)  & 0xff;
		buf->buf[buf->len++] =  (key_len >> 0)  & 0xff;
	}

	if (val_len <= 127) {
		buf->buf[buf->len++] = val_len;
	} else {
		buf->buf[buf->len++] = ((val_len >> 24) & 0xff) | 0x80;
		buf->buf[buf->len++] =  (val_len >> 16) & 0xff;
		buf->buf[buf->len++] =  (val_len >> 8)  & 0xff;
		buf->buf[buf->len++] =  (val_len >> 0)  & 0xff;
	}

	cherokee_buffer_add (buf, key, key_len);
	cherokee_buffer_add (buf, val, val_len);
}


static ret_t
build_initial_packages (cherokee_handler_fastcgi_t *fcgi)
{
	ret_t                    ret;
	cherokee_buffer_t        tmp;
	cherokee_connection_t   *conn;
	FCGI_BeginRequestRecord  request;

	conn = HANDLER_CONN(fcgi);


	/* FCGI_BEGIN_REQUEST
	 */
	fcgi_header_set (&request.header, FCGI_BEGIN_REQUEST, 1, sizeof(request.body), 0);

	request.body.roleB0      = FCGI_RESPONDER;
	request.body.roleB1      = 0;
	request.body.flags       = 0;
	request.body.reserved[0] = 0;
	request.body.reserved[1] = 0;
	request.body.reserved[2] = 0;
	request.body.reserved[3] = 0;
	request.body.reserved[4] = 0;
	
	cherokee_buffer_add (&fcgi->write_buffer, (void *)&request, sizeof(FCGI_BeginRequestRecord));

	/* Add enviroment variables
	 */
	cherokee_buffer_init (&tmp);

	ret = cherokee_cgi_build_basic_env (conn, (cherokee_cgi_set_env_pair_t) add_env_pair, &tmp, &fcgi->write_buffer);
	if (unlikely (ret != ret_ok)) return ret;

	/*
	 */
	
	cherokee_buffer_mrproper (&tmp);

	return ret_ok;
}


ret_t 
cherokee_handler_fastcgi_init (cherokee_handler_fastcgi_t *fcgi)
{
	ret_t ret;

	/* Send the first packet
	 */
	ret = build_initial_packages (fcgi);
	if (unlikely (ret != ret_ok)) return ret;
	
	return ret_ok;
}


ret_t 
cherokee_handler_fastcgi_step (cherokee_handler_fastcgi_t *fcgi, cherokee_buffer_t *buffer)
{
/* 	ret_t  ret; */
/* 	size_t done; */
	
/* 	/\* It has something to send */
/* 	 *\/ */
/* 	if (! cherokee_buffer_is_empty (&fcgi->write_buffer)) { */
/* 		ret = cherokee_socket_write (fcgi->socket, &fcgi->write_buffer, &done); */
/* 		switch (ret) { */
/* 		case ret_ok: */
/* 			break; */
/* 		case ret_eagain: */
/* 			return ret_eagain; */
/* 		case ret_eof: */
/* 		case ret_error: */
/* 			return ret_error; */
/* 		default: */
/* 			SHOULDNT_HAPPEN; */
/* 		} */

/* 		cherokee_buffer_move_to_begin (&fcgi->write_buffer, done); */
/* 	} */

/* 	/\* Lets read */
/* 	 *\/ */
/* 	ret = cherokee_socket_read (fcgi->socket, &fcgi->incoming_buffer, DEFAULT_RECV_SIZE, &done); */
/* 	switch (ret) { */
/* 	case ret_ok: */
/* 	case ret_eof_have_data: */
/* 		printf ("It has read %d\n", done); */
/* 		break; */
/* 	case ret_eagain: */
/* 		cherokee_thread_deactive_to_polling (HANDLER_THREAD(fcgi), HANDLER_CONN(fcgi),  */
/* 						     SOCKET_FD(fcgi->socket), 0); */
/* 		return ret_eagain; */
/* 	case ret_eof: */
/* 		return ret_eof; */
/* 	case ret_error: */
/* 		return ret_error; */
/* 	default: */
/* 		SHOULDNT_HAPPEN; */
/* 	} */


	return ret_ok;
}


ret_t 
cherokee_handler_fastcgi_add_headers (cherokee_handler_fastcgi_t *hdl, cherokee_buffer_t *buffer)
{
	return ret_ok;
}


/* Library init function
 */
void  
fastcgi_init (cherokee_module_loader_t *loader)
{
	PRINT_ERROR_S ("WARNING: The FastCGI is under development, it isn't ready to be used!\n");
}
