/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CHEROKEE_CONFIG_VALUE_H
#define CHEROKEE_CONFIG_VALUE_H

#include "list.h"
#include "buffer.h"

typedef enum {
	   cvalue_unknown = -1,
	   cvalue_number  =  0,
	   cvalue_string,
	   cvalue_keyval,
	   cvalue_list
} cherokee_config_value_type_t;


typedef struct {
	   struct list_head list_item;

	   cherokee_config_value_type_t type;
	   long long                    number;
	   cherokee_buffer_t            string;
	   list_t                       list;

	   struct {
			 cherokee_buffer_t  key;
			 void              *value;
	   } keyval;

} cherokee_config_value_t;

#define CONFVAL(x) ((cherokee_config_value_t *)(x))


ret_t cherokee_config_value_new  (cherokee_config_value_t **value);
ret_t cherokee_config_value_free (cherokee_config_value_t  *value);

ret_t cherokee_config_value_parse     (cherokee_config_value_t **value, char *string);
ret_t cherokee_config_value_serialize (cherokee_config_value_t  *value, cherokee_buffer_t *buf);

#endif /* CHEROKEE_CONFIG_VALUE_H */
