/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <varargs.h>
#include <stdarg.h>

#include "common.h"
#include "log.h"

/* Global mini-buffer for quickly use
 */
char gbl_buffer[gbl_buffer_size];



/* char *  */
/* stristr (char * s1, char * s2) */
/* { */
/* 	   char * ptr = s1; */

/* 	   if (!s1 || !s2 || !*s2) return s1; */

/* 	   while (*ptr) { */
/* 			 if (TOUPPER(*ptr) == TOUPPER(*s2)) { */
/* 				    char * cur1 = ptr + 1; */
/* 				    char * cur2 = s2 + 1; */
/* 				    while (*cur1 && *cur2 && TOUPPER(*cur1) == TOUPPER(*cur2)) { */
/* 						  cur1++; */
/* 						  cur2++; */
/* 				    } */
/* 				    if (!*cur2)	return ptr; */
/* 			 } */
/* 			 ptr++; */
/* 	   } */
/* 	   return NULL; */
/* } */


int
hexit (char c)
{
	if ( c >= '0' && c <= '9' )
		return c - '0';
	if ( c >= 'a' && c <= 'f' )
		return c - 'a' + 10;
	if ( c >= 'A' && c <= 'F' )
		return c - 'A' + 10;

	/* shouldn't happen, we're guarded by isxdigit() */
	return 0;           
}

void 
PRINT_ERROR (const char *format, ...)
{
	va_list arg_list;
	
	/* Print in the stderr
	 */
	va_start(arg_list, format);
	vfprintf(stderr, format, arg_list);
	va_end(arg_list);
	
	/* In the log system too
	 */
	 cherokee_log (LOG_ERR, format, arg_list);
	 
}
