/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "handler_gotls.h"
#include "connection.h"


cherokee_module_info_t cherokee_gotls_info = {
	cherokee_handler,            /* type     */
	cherokee_handler_gotls_new   /* new func */
};

ret_t 
cherokee_handler_gotls_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	CHEROKEE_NEW_STRUCT (n, handler_gotls);
	
	/* Init the base class object
	 */
	cherokee_handler_init_base(HANDLER(n), cnt);

	HANDLER(n)->support = hsupport_nothing;

	MODULE(n)->init         = (handler_func_init_t) cherokee_handler_gotls_init;
	MODULE(n)->free         = (handler_func_free_t) cherokee_handler_gotls_free;
	HANDLER(n)->step        = (handler_func_step_t) cherokee_handler_gotls_step;
	HANDLER(n)->add_headers = (handler_func_add_headers_t) cherokee_handler_gotls_add_headers;
	
	/* Return the object
	 */
	*hdl = HANDLER(n);
	return ret_ok;
}


ret_t 
cherokee_handler_gotls_free (cherokee_handler_gotls_t *dhdl)
{
	return ret_ok;
}


ret_t 
cherokee_handler_gotls_init (cherokee_handler_gotls_t *dhdl)
{
	cherokee_connection_t *conn = CONN(HANDLER(dhdl)->connection);

	if (conn->header->version < http_version_11) {
		conn->error_code = http_access_denied;
		return ret_ok;
	}

	conn->error_code = http_update_required;
	return ret_ok;
}


ret_t 
cherokee_handler_gotls_add_headers (cherokee_handler_gotls_t *dhdl, cherokee_buffer_t *buffer)
{
	ret_t ret;

	ret = cherokee_buffer_add (buffer, "Update: TLS/1.0, HTTP/1.1"CRLF, 27);
	if (ret < ret_ok) return ret;

	return ret_error;
}

ret_t 
cherokee_handler_gotls_step (cherokee_handler_gotls_t *dhdl, cherokee_buffer_t *buffer)
{
	SHOULDNT_HAPPEN;
	return ret_error;
}


/* Library init function
 */
static cherokee_boolean_t _gotls_is_init = false;

void 
gotls_init (void)
{
	if (_gotls_is_init)
		return;
	
	_gotls_is_init = true;
}
