/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_BENCH_INFO_H__
#define __CHEROKEE_BENCH_INFO_H__

#include "common.h"


typedef struct {
	unsigned long tx, rx;
	unsigned long transfers;
	unsigned long keepalive;

	struct {
		uint32_t code[20]; /* x01, x02, ..., x19 */
	} error[4];                /* 1xx, 2xx, 3xx, 4xx */

} cherokee_bench_info_t;


ret_t cherokee_bench_info_init  (cherokee_bench_info_t *info);
ret_t cherokee_bench_info_clean (cherokee_bench_info_t *info);

ret_t cherokee_bench_info_print (cherokee_bench_info_t *info);
ret_t cherokee_bench_info_add   (cherokee_bench_info_t *info, cherokee_bench_info_t *to_add);

#endif /* __CHEROKEE_BENCH_INFO_H__  */
