/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "connection.h"
#include "handler_redir.h"
#include "module.h"


cherokee_module_info_t cherokee_redir_info = {
	cherokee_handler,             /* type     */
	cherokee_handler_redir_new    /* new func */
};

ret_t 
cherokee_handler_redir_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	CHEROKEE_NEW_STRUCT (n, handler_redir);
	
	/* Init the base class object
	 */
	cherokee_handler_init_base(HANDLER(n), cnt);

	MODULE(n)->init         = (handler_func_init_t) cherokee_handler_redir_init;
	MODULE(n)->free         = (handler_func_free_t) cherokee_handler_redir_free;
	HANDLER(n)->add_headers = (handler_func_add_headers_t) cherokee_handler_redir_add_headers;

	HANDLER(n)->connection  = cnt;
	HANDLER(n)->support     = hsupport_nothing;
	
	if (properties) {
		n->target_url = cherokee_table_get_val (properties, "url");
		n->target_url_len = strlen(n->target_url);
	}

	*hdl = HANDLER(n);
	
	return ret_ok;	   
}


ret_t 
cherokee_handler_redir_init (cherokee_handler_redir_t *n)
{
	int                    request_end;
	char                  *request_endding;
	cherokee_connection_t *conn;

	conn = CONN(HANDLER(n)->connection);
	
	request_end = (conn->request->len - conn->web_directory->len);
	request_endding = conn->request->buf + conn->web_directory->len;

	cherokee_buffer_ensure_size (conn->redirect, request_end + n->target_url_len +1);

	cherokee_buffer_add (conn->redirect, n->target_url, n->target_url_len);
	cherokee_buffer_add (conn->redirect, request_endding, request_end);

	CONN(HANDLER(n)->connection)->error_code = http_moved_permanently;
	return ret_error;
}


ret_t 
cherokee_handler_redir_free (cherokee_handler_redir_t *rehdl)
{
	free (rehdl);	
	return ret_ok;
}


ret_t 
cherokee_handler_redir_add_headers (cherokee_handler_redir_t *rehdl, cherokee_buffer_t *buffer)
{
	cherokee_connection_t *conn = CONN(HANDLER(rehdl)->connection);
	
	if (!cherokee_buffer_is_empty (conn->redirect)) {
		cherokee_buffer_add (buffer, "Location: ", 10);
//		cherokee_buffer_add (buffer, HANDLER(rehdl)->redirect, strlen(HANDLER(rehdl)->redirect));
		cherokee_buffer_add_buffer (buffer, conn->redirect);
		cherokee_buffer_add (buffer, CRLF, 2);
	}

	return ret_ok;
}



/* Library init function
 */

void 
redir_init (void)
{

}
