/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "module.h"
#include "handler_phpcgi.h"
#include "handler_cgi.h"
#include "connection.h"

#define PHP_EXECUTABLE "/usr/lib/cgi-bin/php4"


cherokee_module_info_t cherokee_phpcgi_info = {
	cherokee_handler,           /* type     */
	cherokee_handler_phpcgi_new /* new func */
};


ret_t 
cherokee_handler_phpcgi_new  (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	cherokee_handler_cgi_new (hdl, cnt, properties);
	   
	/* Redefine the init method
	 */
	MODULE(*hdl)->init = (handler_func_init_t) cherokee_handler_phpcgi_init;

	return ret_ok;
}


static void
change_to_php_script_directory (cherokee_buffer_t *filepath)
{
	char *end;

	end = rindex (filepath->buf, '/');
	if (end == NULL) return;

	*end = '\0';
	chdir (filepath->buf);
	*end = '/';
}


ret_t 
cherokee_handler_phpcgi_init (cherokee_handler_t *hdl)
{
	cherokee_connection_t *conn = HANDLER_CONN(hdl);
	
	if (CGIHANDLER_FILE(hdl) == NULL) {
		cherokee_buffer_new (&CGIHANDLER_FILE(hdl));
		cherokee_buffer_add ( CGIHANDLER_FILE(hdl), PHP_EXECUTABLE, strlen(PHP_EXECUTABLE));
	}
	
	if (CGIHANDLER_PARAM(hdl) == NULL) {
		cherokee_buffer_new (&CGIHANDLER_PARAM(hdl));
		cherokee_buffer_add_buffer (CGIHANDLER_PARAM(hdl), conn->local_directory);
		cherokee_buffer_add_buffer (CGIHANDLER_PARAM(hdl), conn->request);

		change_to_php_script_directory (CGIHANDLER_PARAM(hdl));
	}

	setenv ("REDIRECT_STATUS", "200", 1);
	setenv ("SCRIPT_FILENAME", CGIHANDLER_PARAM(hdl)->buf, 1);
		
	return cherokee_handler_cgi_init (CGIHANDLER(hdl));
}


/*   Library init function
 */
static int _phpcgi_is_init = 0;

void
phpcgi_init ()
{
	int re;
	struct stat buf;
	
	/* Is init?
	 */
	if (_phpcgi_is_init) {
		return;
	}
	
	/* Init the dependences
	 */
	cgi_init();
	
	/* Check for the PHP executable 
	 */
	re = stat (PHP_EXECUTABLE, &buf);
	if ((re != 0) || (!S_ISREG(buf.st_mode))) {
		PRINT_ERROR ("PHP interpreter not found (%s). Please install it.\n", PHP_EXECUTABLE);
	}
	
	_phpcgi_is_init = 1;
}


