from CherokeeTest import *

list = ["Test01", "TestRangeFrom", "TestRangeTo", "TestRangeFromTo",
        "TestOutOfRangeOverflow", "TestOutOfRangeSwitched", "TestErrorDocumentRedirect"]


def random_string (length):
    from random import randint, seed
    from string import lowercase, uppercase, digits

    chars = lowercase + uppercase + digits
    chars_len = len(chars)

    seed()
    ret=""
    for i in range(length):
        ret += chars[randint(0,chars_len-1)]

    return ret


class Test01 (CherokeeTest):
    def __init__ (self):
        from base64 import encodestring
        from random import randint
        
        CherokeeTest.__init__(self)

        self.__name__    = "data consistency"
        self.__port__    = 1111
        self.__content__ = encodestring(random_string(randint(2000,100000)))

    def AnalizeResult (self):
        import httplib

        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/index.html")

        response = conn.getresponse()
        if response.status != 200:
            print "Wrong response:", response.status
            return True

        data = response.read()
        if data != self.__content__:            
            print "Wrong response data"
            return True

        conn.close()
        return False

    def GenerateConfig (self):
        tmpdir = self.MakeTempDir()
        self.WriteFile (tmpdir, "index.html", self.__content__)
        
        return """
        Port %s
        DocumentRoot %s/
        Directory / { Handler file }
        """ % (self.__port__, tmpdir)


class TestRange (Test01):
    def __init__ (self):
        Test01.__init__ (self)
        self.__range_start__ = None
        self.__range_end__   = None

    def AnalizeResult (self):
        import httplib

        if self.__range_start__ and self.__range_end__:
            headers = {"Range": "bytes=%d-%d" % (self.__range_start__, self.__range_end__)}
        elif self.__range_start__:
            headers = {"Range": "bytes=%d-" % (self.__range_start__)}
        elif self.__range_end__:
            headers = {"Range": "bytes=-%d" % (self.__range_end__)}
        else:
            raise "Shouldn't happend"
            
        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/index.html", headers=headers)

        response = conn.getresponse()
        if response.status != 206:
            print "Wrong response:", response.status, response.reason
            return True

        if self.__range_start__ == None:
            self.__range_start__ = 0
        if self.__range_end__ == None:
            self.__range_end__ = len(self.__content__)

        data = response.read()
        if data != self.__content__[self.__range_start__:self.__range_end__]:            
            if data == self.__content__:
                print "Wrong response data: Web server didn't use the range"
                return True

            len_data = len(data)
            len_cont = len(self.__content__)
            print "Wrong response data: %d instead if %d" % (len_data, len(self.__content__[self.__range_start__:self.__range_end__]))
            return True

        conn.close()
        return False


class TestOutOfRange (TestRange):
    def __init__ (self):
        TestRange.__init__ (self)
        self.__name__ = "out of range detection"

    def AnalizeResult (self):
        import httplib

        if self.__range_start__ and self.__range_end__:
            headers = {"Range": "bytes=%d-%d" % (self.__range_start__, self.__range_end__)}
        elif self.__range_start__:
            headers = {"Range": "bytes=%d-" % (self.__range_start__)}
        elif self.__range_end__:
            headers = {"Range": "bytes=-%d" % (self.__range_end__)}
        else:
            raise "Shouldn't happend"
            
        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/index.html", headers=headers)

        response = conn.getresponse()
        if response.status != 416:
            print "Wrong response:", response.status, response.reason
            return True

        conn.close()
        return False


class TestRangeFrom (TestRange):
    def __init__ (self):
        TestRange.__init__ (self)
        self.__name__ = "range support 'from'"

    def AnalizeResult (self):
        from random import randint
        self.__range_start__ = randint(0, len(self.__content__))
        return TestRange.AnalizeResult (self)


class TestRangeTo (TestRange):
    def __init__ (self):
        TestRange.__init__ (self)
        self.__name__ = "range support 'to'"

    def AnalizeResult (self):
        from random import randint
        self.__range_end__ = randint(0, len(self.__content__))
        return TestRange.AnalizeResult (self)


class TestRangeFromTo (TestRange):
    def __init__ (self):
        TestRange.__init__ (self)
        self.__name__ = "range support 'from-to'"

    def AnalizeResult (self):
        from random import randint
        r1 = randint(0, len(self.__content__))
        r2 = randint(0, len(self.__content__))
        self.__range_start__ = min(r1,r2)
        self.__range_end__   = max(r1,r2)
        return TestRange.AnalizeResult (self)


class TestOutOfRangeOverflow (TestOutOfRange):
    def __init__ (self):
        TestOutOfRange.__init__ (self)
        self.__name__ = "overflow range detection"

    def AnalizeResult (self):
        from random import randint
        cont_len = len(self.__content__)
        self.__range_start__ = cont_len + randint(0, cont_len)
        return TestOutOfRange.AnalizeResult (self)


class TestOutOfRangeSwitched (TestOutOfRange):
    def __init__ (self):
        TestOutOfRange.__init__ (self)
        self.__name__ = "switched range detection"

    def AnalizeResult (self):
        from random import randint
        r1 = randint(0, len(self.__content__))
        r2 = randint(0, len(self.__content__))
        self.__range_start__ = max(r1,r2)
        self.__range_end__   = min(r1,r2)
        return TestOutOfRange.AnalizeResult (self)


class TestErrorDocumentRedirect (CherokeeTest):
    def __init__ (self):
        CherokeeTest.__init__(self)

        self.__port__    = 1111
        self.__name__    = "ErrorDocument 404"

    def AnalizeResult (self):
        import httplib

        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/this_doesnt_exist")

        response = conn.getresponse()
        if response.status not in (301, 302):
            print "Wrong response:", response.status
            return True

        conn.close()
        return False

    def GenerateConfig (self):        
        tmpdir = self.MakeTempDir()

        return """
        Port %s
        DocumentRoot %s/
        ErrorDocument 404 http://localhost:%s/error404.html
        Directory / { Handler file }
        """ % (self.__port__, tmpdir, self.__port__)
