/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_BENCH_CONNECTION_H__
#define __CHEROKEE_BENCH_CONNECTION_H__

#include "common.h"

#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include "buffer.h"
#include "list.h"
#include "header.h"
#include "socket.h"
#include "request.h"
#include "info.h"

#define CONN_READ_SIZE 2048


typedef enum {
	keepalive_disable,
	keepalive_enable
} cherokee_keepalive_t;


typedef struct {
	struct list_head   list_entry;
	void              *thread;

	cherokee_bench_info_t    info;
	cherokee_keepalive_t     keepalive;
	cherokee_http_t          error_code;

	cherokee_bench_request_t *req;
	cherokee_buffer_t        *req_string;

	cherokee_buffer_t        *buffer;
	cherokee_header_t        *header;
	
	cherokee_socket_t  *socket;
	struct sockaddr_in  address;

	int readed;
	int iterations;
	int content_length;

	enum {
		init,
		writing,
		reading_header,
		reading_body,
		closed
	} state;

} cherokee_bench_connection_t;

#define CONN(c)        ((cherokee_bench_connection_t *)(c))
#define CONN_THREAD(c) (CONN(c)->thread)
#define CONN_SOCK(c)   (CONN(c)->socket)
#define CONN_REQ(c)    (CONN(c)->req)
#define CONN_INFO(c)   (CONN(c)->info)


ret_t cherokee_bench_connection_new   (cherokee_bench_connection_t **conn);
ret_t cherokee_bench_connection_free  (cherokee_bench_connection_t  *conn);

ret_t cherokee_bench_connection_connect (cherokee_bench_connection_t *conn);
ret_t cherokee_bench_connection_step    (cherokee_bench_connection_t *conn);
ret_t cherokee_bench_connection_reset   (cherokee_bench_connection_t *conn);


/* Low level methods
 */
ret_t cherokee_bench_connection_set_mode (cherokee_bench_connection_t *conn, cherokee_socket_status_t status);

#endif /* __CHEROKEE_BENCH_CONNECTION_H__  */
