#! /usr/bin/python

def is_test_file (filename):
    return filename[:4] == "Test" and filename[-3:] == ".py"

def do_test_dir (dir):
    from os import listdir
    from os.path import join
    from new import instance

    for file in filter(is_test_file, listdir(dir)):
        module = {}
        name   = file[:-3]

        execfile (join (dir, file), module)
        for class_name in module["list"]:
            test_obj = instance(module[class_name])
            test_obj.__init__()
            print "Running %s test.." % (test_obj.__name__),
            ret = test_obj.Run()
            del test_obj

            if ret == True:
                print "Error running test %s, class=%s" % (name, class_name)
                return True

            print "OK!"

    return False


if __name__ == "__main__":
    from sys import argv

    if len(argv) <= 1:
        print "Addind default tests directory 'tests'.."
        argv.append("tests")

    for d in argv[1:]:
        do_test_dir (d)
