from CherokeeTest import *

list = ["Test01", "TestRangeFrom", "TestRangeTo", "TestRangeFromTo"]


def random_string (length):
    from random import randint, seed
    from string import lowercase, uppercase, digits

    chars = lowercase + uppercase + digits
    chars_len = len(chars)

    seed()
    ret=""
    for i in range(length):
        ret += chars[randint(0,chars_len-1)]

    return ret


class Test01 (CherokeeTest):
    def __init__ (self):
        from base64 import encodestring
        from random import randint
        
        CherokeeTest.__init__(self)

        self.__name__    = "data consistency"
        self.__port__    = 1111
        self.__content__ = encodestring(random_string(randint(2000,10000)))

    def AnalizeResult (self):
        import httplib

        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/index.html")

        response = conn.getresponse()
        if response.status != 200:
            print "Wrong response:", response.status
            return True

        data = response.read()
        if data != self.__content__:            
            print "Wrong response data"
            return True

        conn.close()
        return False

    def GenerateConfig (self):
        tmpdir = self.MakeTempDir()
        self.WriteFile (tmpdir, "index.html", self.__content__)
        
        return """
        Port %s
        DocumentRoot %s/
        Directory / { Handler file }
        """ % (self.__port__, tmpdir)


class TestRangeFrom (Test01):
    def __init__ (self):
        Test01.__init__ (self)
        self.__name__ = "range support 'from'"


    def AnalizeResult (self):
        import httplib
        from random import randint

        cont_len = len(self.__content__)
        self.__range__ = randint (0, cont_len)
        headers = {"Range": "bytes=%d-" % (self.__range__)}
        self.Debug(DEBUG_INTERNAL, "Range: bytes=%d- (total of %d)" % (self.__range__, cont_len))

        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/index.html", headers=headers)

        response = conn.getresponse()
        if response.status != 206:
            print "Wrong response:", response.status, response.reason
            return True

        data = response.read()
        if data != self.__content__[self.__range__:]:            
            len_data = len(data)
            len_cont = len(self.__content__)
            if len_data == len_cont:
                print "Wrong response data: Web server didn't use the range"
            else:
                print "Wrong response data: %d instead if %d" %(len_data, len(self.__content__[self.__range__:]))
            return True

        conn.close()
        return False


class TestRangeTo (Test01):
    def __init__ (self):
        Test01.__init__ (self)
        self.__name__ = "range support 'to'"


    def AnalizeResult (self):
        import httplib
        from random import randint

        cont_len = len(self.__content__)
        self.__range__ = randint (0, cont_len)
        headers = {"Range": "bytes=-%d" % (self.__range__)}
        self.Debug(DEBUG_INTERNAL, "Range: bytes=-%d (total of %d)" % (self.__range__, cont_len))

        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/index.html", headers=headers)

        response = conn.getresponse()
        if response.status != 206:
            print "Wrong response:", response.status, response.reason
            return True

        data = response.read()
        if data != self.__content__[:self.__range__]:            
            len_data = len(data)
            len_cont = len(self.__content__)
            if len_data == len_cont:
                print "Wrong response data: Web server didn't use the range"
            else:
                print "Wrong response data: %d instead if %d" %(len_data, len(self.__content__[:self.__range__]))
            return True

        conn.close()
        return False


class TestRangeFromTo (Test01):
    def __init__ (self):
        Test01.__init__ (self)
        self.__name__ = "range support 'from to'"

    def AnalizeResult (self):
        import httplib
        from random import randint

        cont_len = len(self.__content__)
        r1 = randint (0, cont_len)
        r2 = randint (0, cont_len)
        self.__range__ = (min(r1,r2), max(r1,r2))
        headers = {"Range": "bytes=%d-%d" % (self.__range__[0], self.__range__[1])}

        conn = httplib.HTTPConnection("localhost:%s" % (self.__port__))
        conn.request("GET", "/index.html", headers=headers)

        response = conn.getresponse()
        if response.status != 206:
            print "Wrong response:", response.status, response.reason
            return True

        data = response.read()
        if data != self.__content__[self.__range__[0]:self.__range__[1]]:            
            len_data = len(data)
            len_cont = len(self.__content__)
            if len_data == len_cont:
                print "Wrong response data: Web server didn't use the range"
            else:
                print "Wrong response data: %d instead if %d" %(len_data, len(self.__content__[self.__range__[0]:self.__range__[1]]))
            return True

        conn.close()
        return False
