/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *      Hiroshi Yamashita <piro7@SoftHome.net>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_FD_POLL_H__
#define __CHEROKEE_FD_POLL_H__

#include "common.h"


#if defined HAVE_EPOLL
# include <sys/epoll.h>
# define USE_EPOLL
#elif defined HAVE_KQUEUE
# include <sys/types.h>
# include <sys/event.h>
# define USE_KQUEUE
#elif defined HAVE_SYS_POLL_H
# include <sys/poll.h>
# define USE_POLL
#elif defined HAVE_POOL_H
# include <poll.h>
# define USE_POLL
#elif defined HAVE_SYS_SELECT
# include <sys/select.h>
# define USE_SELECT
#else
# error No pooling method found!
#endif


/* <DEBUGGING>
 */
/*
#undef  USE_POLL
#undef  USE_EPOLL
#undef  USE_SELECT
#define USE_SELECT

# include <sys/select.h>
*/
/* </DEBUGGING>
 */


#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif


typedef enum {
	   fdp_read  = 0,
	   fdp_write = 1
} cherokee_fdpoll_rw_t;



typedef struct {
	int nfiles;

#ifdef USE_EPOLL
	int                 ep_fd;
	struct epoll_event *ep_events;
	int                 ep_readyfds;
	int                *epoll_rs2idx;
	int                *epoll_idx2rs;
#endif

#ifdef USE_POLL
	struct pollfd *pollfds;
	int            npollfds;
	int           *fdidx;
#endif

#ifdef USE_KQUEUE
        int  kq;
        struct kevent *eventlist;
        struct kevent *changelist;
        int  nevents;
        int  nchanges;
        int  *clidx;
        int  *elidx;
#endif

#ifdef USE_SELECT
	int    *fd_rw;

	fd_set  master_rfdset;
	fd_set  master_wfdset;
	fd_set  working_rfdset;
	fd_set  working_wfdset;
	int    *select_fds;
	int    *select_fdidx;
	int    *select_rfdidx;
	int     nselect_fds;
	int     maxfd;
	int     maxfd_changed;
#endif

#ifdef HAVE_PTHREAD
	pthread_rwlock_t rwlock;
#endif
} cherokee_fdpoll_t;


#ifdef USE_EPOLL
# define cherokee_fdpoll_new        fdpoll_epoll_new
# define cherokee_fdpoll_free       fdpoll_epoll_free
# define cherokee_fdpoll_add        fdpoll_epoll_add
# define cherokee_fdpoll_del        fdpoll_epoll_del
# define cherokee_fdpoll_set_mode   fdpoll_epoll_set_mode
# define cherokee_fdpoll_watch      fdpoll_epoll_watch
# define cherokee_fdpoll_check      fdpoll_epoll_check
# define cherokee_fdpoll_reset      fdpoll_epoll_reset
# define cherokee_fdpoll_get_method fdpoll_epoll_get_method
#endif

#ifdef USE_POLL
# define cherokee_fdpoll_new        fdpoll_poll_new
# define cherokee_fdpoll_free       fdpoll_poll_free
# define cherokee_fdpoll_add        fdpoll_poll_add
# define cherokee_fdpoll_del        fdpoll_poll_del
# define cherokee_fdpoll_set_mode   fdpoll_poll_set_mode
# define cherokee_fdpoll_watch      fdpoll_poll_watch
# define cherokee_fdpoll_check      fdpoll_poll_check
# define cherokee_fdpoll_reset      fdpoll_poll_reset
# define cherokee_fdpoll_get_method fdpoll_poll_get_method
#endif

#ifdef USE_KQUEUE
# define cherokee_fdpoll_new      fdpoll_kqueue_new
# define cherokee_fdpoll_free     fdpoll_kqueue_free
# define cherokee_fdpoll_add      fdpoll_kqueue_add
# define cherokee_fdpoll_del      fdpoll_kqueue_del
# define cherokee_fdpoll_set_mode fdpoll_kqueue_set_mode
# define cherokee_fdpoll_watch    fdpoll_kqueue_watch
# define cherokee_fdpoll_check    fdpoll_kqueue_check
# define cherokee_fdpoll_reset    fdpoll_kqueue_reset
# define cherokee_fdpoll_get_method fdpoll_kqueue_get_method
#endif

#ifdef USE_SELECT
# define cherokee_fdpoll_new        fdpoll_select_new
# define cherokee_fdpoll_free       fdpoll_select_free
# define cherokee_fdpoll_add        fdpoll_select_add
# define cherokee_fdpoll_del        fdpoll_select_del
# define cherokee_fdpoll_set_mode   fdpoll_select_set_mode
# define cherokee_fdpoll_watch      fdpoll_select_watch
# define cherokee_fdpoll_check      fdpoll_select_check
# define cherokee_fdpoll_reset      fdpoll_select_reset
# define cherokee_fdpoll_get_method fdpoll_select_get_method
#endif


ret_t cherokee_fdpoll_new        (cherokee_fdpoll_t **fdp, int fd_limit);
ret_t cherokee_fdpoll_free       (cherokee_fdpoll_t  *fdp);
ret_t cherokee_fdpoll_get_method (cherokee_fdpoll_t  *fdp, char **name);   

ret_t cherokee_fdpoll_add      (cherokee_fdpoll_t  *fdp, int fd, int rw);
ret_t cherokee_fdpoll_del      (cherokee_fdpoll_t  *fdp, int fd);
void  cherokee_fdpoll_set_mode (cherokee_fdpoll_t  *fdp, int fd, int rw);
int   cherokee_fdpoll_check    (cherokee_fdpoll_t  *fdp, int fd, int rw);
int   cherokee_fdpoll_watch    (cherokee_fdpoll_t  *fdp, int timeout_msecs);


#endif /* __CHEROKEE_FD_POLL_H__ */
