/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "url.h"

ret_t 
cherokee_url_new  (cherokee_url_t **url)
{
	   ret_t ret;
	   CHEROKEE_NEW_STRUCT(n, url);

	   /* New buffer objects
	    */
	   ret = cherokee_buffer_new (&n->host);
	   if (ret < ret_ok) return ret;

	   ret = cherokee_buffer_new (&n->request);
	   if (ret < ret_ok) return ret;

	   /* Set default values
	    */
	   n->port = 80;

	   /* Return the object
	    */
	   *url = n;
	   return ret_ok;
}


ret_t 
cherokee_url_free (cherokee_url_t *url)
{
	if (url->host != NULL) {
		cherokee_buffer_free (url->host);
		url->host = NULL;
	}
	
	if (url->request != NULL) {
		cherokee_buffer_free (url->request);
		url->request = NULL;
	}
	
	free (url);
	return ret_ok;
}


static char *
drop_protocol (char *url)
{
	/* Drop "http://"
	 */
	if (strncasecmp("http://", url, 7) == 0) {
		return url+7;
	}

	/* Drop "https://"
	 */
	if (strncasecmp("https://", url, 8) == 0) {
		return url+8;
	}

	return url;
}


ret_t 
cherokee_url_parse (cherokee_url_t *url, char *url_string)
{
	int    len;
	ret_t  ret;
	char  *port;
	char  *slash;
	char  *server;

	/* Drop protocol, if exists..
	 */
	server = drop_protocol (url_string);

	/* Split the host/request
	 */
	len   = strlen (server);
	slash = strpbrk (server, "/\\");
	
	if (slash == NULL) {
		cherokee_buffer_add (url->request, "/", 1);
		cherokee_buffer_add (url->host, server, len);
	} else {
		cherokee_buffer_add (url->request, slash, len-(slash-server));
		cherokee_buffer_add (url->host, server, slash-server);
	}

	/* Drop up the port, if exists..
	 */
	port = index (url->host->buf, ':');
	if (port != NULL) {

		/* Read port number
		 */
		if (slash != NULL) slash = '\0';
		URL_PORT(url) = atoi (port+1);
		if (slash != NULL) slash =  '/';

		/* .. and remove it
		 */
		ret = cherokee_buffer_drop_endding (url->request, strlen(port));
		if (ret < ret_ok) return ret;
	}
	
#if 0
	cherokee_url_print (url);
#endif
	   
	return ret_ok;
}


ret_t 
cherokee_url_build_string (cherokee_url_t *url, cherokee_buffer_t *buf)
{
	cherokee_buffer_add_buffer (buf, url->host);

	if (url->port != 80) {
		cherokee_buffer_add_va (buf, ":%d", url->port);
	}

	cherokee_buffer_add_buffer (buf, url->request);

	return ret_ok;
}


ret_t 
cherokee_url_print (cherokee_url_t *url)
{
	printf ("Host:    %s\n", url->host->buf);
	printf ("Request: %s\n", url->request->buf);
	printf ("Port:    %d\n", url->port);

	return ret_ok;
}
