/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_BENCH_THREAD_H__
#define __CHEROKEE_BENCH_THREAD_H__

#include "common.h"

#include <time.h>
#include <pthread.h>

#include "list.h"
#include "bench.h"
#include "connection.h"
#include "fdpoll.h"


#define ERRORS_MAX_CONNECTIONS 10

typedef enum {
	thread_error = -1,
	thread_ok    =  0
} cherokee_bench_thread_error_t;


typedef struct {
	struct list_head   list_entry;
	pthread_t          thread;
        void              *bench; 
	cherokee_fdpoll_t *fdpoll;

	uint32_t  conns_todo;
	list_t    conns_list;

	struct {
		unsigned int connection;
		unsigned int aborted;
	} errors;

	cherokee_bench_info_t         info;
	cherokee_bench_thread_error_t error;

} cherokee_bench_thread_t;


#define THREAD(b)            ((cherokee_bench_thread_t *)(b))
#define THREAD_BENCH(b)      ((cherokee_bench_t *) THREAD(b)->bench)
#define THREAD_FDPOLL(b)     ((cherokee_fdpoll_t *) THREAD(b)->fdpoll)
#define THREAD_ERROR(b)      (THREAD(b)->error)
#define THREAD_CONNS_TODO(b) (THREAD(b)->conns_todo)

ret_t cherokee_bench_thread_new  (cherokee_bench_thread_t **thread, void *bench);
ret_t cherokee_bench_thread_free (cherokee_bench_thread_t  *thread);
ret_t cherokee_bench_thread_run  (cherokee_bench_thread_t  *thread);

#endif /* __CHEROKEE_BENCH_THREAD_H__  */

