/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_REQUEST_H__
#define __CHEROKEE_REQUEST_H__

#include "common.h"
#include "url.h"
#include "http.h"

typedef struct {
	   struct list_head  list_entry;
	   cherokee_url_t   *url;

	   uint16_t                pipeline;
	   cherokee_boolean_t      keepalive;
	   cherokee_http_method_t  method;
	   cherokee_http_version_t version;

} cherokee_bench_request_t;

#define REQUEST(r)           ((cherokee_bench_request_t *)(r))
#define REQUEST_METHOD(r)    (REQUEST(r)->method)
#define REQUEST_VERSION(r)   (REQUEST(r)->version)
#define REQUEST_PIPELINE(r)  (REQUEST(r)->pipeline)
#define REQUEST_KEEPALIVE(r) (REQUEST(r)->keepalive)
#define REQUEST_URL(r)       (URL(REQUEST(r)->url))

ret_t cherokee_bench_request_new   (cherokee_bench_request_t **request);
ret_t cherokee_bench_request_free  (cherokee_bench_request_t  *request);

ret_t cherokee_bench_request_build_string (cherokee_bench_request_t *request, cherokee_buffer_t *buf);


#endif /* __CHEROKEE_REQUEST_H__ */
