/* A Bison parser, made by GNU Bison 1.875a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_DOCUMENT = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_SERVER = 274,
     T_USERDIR = 275,
     T_URL = 276,
     T_PIDFILE = 277,
     T_LISTEN = 278,
     T_FILEDIR = 279,
     T_HIDE_VERSION = 280,
     T_HIDE_SERVER_NAME = 281,
     T_ENCODER = 282,
     T_ALLOW = 283,
     T_BGCOLOR = 284,
     T_TEXT = 285,
     T_LINK = 286,
     T_ALINK = 287,
     T_VLINK = 288,
     T_BACKGROUND = 289,
     T_DIRECTORYINDEX = 290,
     T_IPV6 = 291,
     T_SHOW = 292,
     T_CHROOT = 293,
     T_HEADER_FILE = 294,
     T_ICONS = 295,
     T_AUTH = 296,
     T_NAME = 297,
     T_METHOD = 298,
     T_PASSWDFILE = 299,
     T_SSL_CA_LIST_FILE = 300,
     T_FROM = 301,
     T_SOCKET = 302,
     T_NUMBER = 303,
     T_PORT = 304,
     T_QSTRING = 305,
     T_FULLDIR = 306,
     T_ID = 307,
     T_HTTP_URL = 308,
     T_HOSTNAME = 309,
     T_IP = 310
   };
#endif
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_DOCUMENT 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_SERVER 274
#define T_USERDIR 275
#define T_URL 276
#define T_PIDFILE 277
#define T_LISTEN 278
#define T_FILEDIR 279
#define T_HIDE_VERSION 280
#define T_HIDE_SERVER_NAME 281
#define T_ENCODER 282
#define T_ALLOW 283
#define T_BGCOLOR 284
#define T_TEXT 285
#define T_LINK 286
#define T_ALINK 287
#define T_VLINK 288
#define T_BACKGROUND 289
#define T_DIRECTORYINDEX 290
#define T_IPV6 291
#define T_SHOW 292
#define T_CHROOT 293
#define T_HEADER_FILE 294
#define T_ICONS 295
#define T_AUTH 296
#define T_NAME 297
#define T_METHOD 298
#define T_PASSWDFILE 299
#define T_SSL_CA_LIST_FILE 300
#define T_FROM 301
#define T_SOCKET 302
#define T_NUMBER 303
#define T_PORT 304
#define T_QSTRING 305
#define T_FULLDIR 306
#define T_ID 307
#define T_HTTP_URL 308
#define T_HOSTNAME 309
#define T_IP 310




/* Copy the first part of user declarations.  */
#line 1 "read_config_grammar.y"

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common.h"

#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#include "mime.h"
#include "server.h"
#include "table.h"
#include "virtual_server.h"
#include "handler_table_entry.h"
#include "encoder.h"
#include "logger_table.h"
#include "access.h"
#include "list_ext.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 56 "read_config_grammar.y"
typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *list;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 253 "read_config_grammar.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 70 "read_config_grammar.y"

/* What is the right way to import this prototipe?
 */
extern int yylex(void);


extern char *yytext;
extern int   yylineno;

cherokee_virtual_server_t      *current_virtual_server      = NULL;
cherokee_handler_table_entry_t *current_handler_table_entry = NULL;
cherokee_encoder_table_entry_t *current_encoder_entry       = NULL;
cherokee_module_info_t         *current_module_info         = NULL;
list_t                         *current_list                = NULL;

struct {
	   char                          *handler_name;
	   cherokee_handler_table_entry_t *entry;
	   cherokee_virtual_server_t     *vserver;
	   char                          *document_root;
	   char                          *directory_name;
} directory_content_tmp;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)


static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new = (char*) malloc ((*len)+2);
	   memcpy (new, string, *len);
	   new[(*len)] = '/';
	   new[(*len)+1] = '\0';
	   free (string);

	   (*len)++;

	   return new;
}


cherokee_handler_table_entry_t *
handler_table_entry_new (void)
{
	   cherokee_handler_table_entry_t *entry;

	   cherokee_handler_table_entry_new (&entry);
	   current_handler_table_entry = entry;

	   return entry;
}


char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}


void
yyerror(char* msg)
{
        PRINT_ERROR ("Error parsing configuration: '%s', line %d, symbol '%s'\n", 
				 msg, yylineno, yytext);
}



/* Line 214 of yacc.c.  */
#line 374 "read_config_grammar.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  91
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   140

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  59
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  57
/* YYNRULES -- Number of rules. */
#define YYNRULES  115
/* YYNRULES -- Number of states. */
#define YYNSTATES  180

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   310

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    56,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    57,     2,    58,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    77,
      80,    81,    84,    85,    88,    89,    92,    94,    98,   100,
     104,   107,   110,   113,   114,   119,   120,   124,   125,   128,
     131,   134,   137,   140,   143,   146,   149,   152,   155,   158,
     161,   164,   165,   172,   175,   178,   181,   184,   187,   190,
     193,   196,   199,   202,   208,   211,   214,   217,   220,   223,
     226,   229,   232,   235,   238,   241,   243,   245,   246,   253,
     254,   261,   263,   266,   272,   276,   279,   283,   287,   288,
     289,   292,   295,   301,   304,   308
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      60,     0,    -1,    -1,    61,    -1,    63,    -1,    61,    63,
      -1,    65,    -1,    62,    65,    -1,    65,    -1,    64,    -1,
     104,    -1,    72,    -1,    73,    -1,    80,    -1,    81,    -1,
      82,    -1,    83,    -1,    84,    -1,    85,    -1,    86,    -1,
      93,    -1,    97,    -1,    98,    -1,    99,    -1,   100,    -1,
     113,    -1,    94,    -1,    95,    -1,    96,    -1,   114,    -1,
     115,    -1,   106,    -1,    74,    -1,    75,    -1,    90,    -1,
      87,    -1,    88,    -1,    89,    -1,    -1,    66,   102,    -1,
      -1,    67,   108,    -1,    -1,    68,    92,    -1,    -1,    69,
     109,    -1,    52,    -1,    52,    56,    70,    -1,    55,    -1,
      55,    56,    71,    -1,    49,    48,    -1,    23,   103,    -1,
      12,    51,    -1,    -1,    13,    52,    76,    77,    -1,    -1,
      57,    78,    58,    -1,    -1,    78,    79,    -1,    52,    51,
      -1,    25,    48,    -1,    26,    48,    -1,    14,    51,    -1,
      40,    51,    -1,    10,    48,    -1,    11,    48,    -1,     8,
      48,    -1,     7,    51,    -1,     6,    51,    -1,    45,    51,
      -1,    27,    52,    -1,    -1,    27,    52,    57,    91,    68,
      58,    -1,    28,    70,    -1,     4,    70,    -1,    22,    51,
      -1,    38,    51,    -1,     5,    48,    -1,    36,    48,    -1,
      17,    52,    -1,    17,    48,    -1,    18,    52,    -1,    18,
      48,    -1,    16,    52,    57,    66,    58,    -1,    16,    52,
      -1,    21,    53,    -1,    24,    51,    -1,    29,    52,    -1,
      30,    52,    -1,    31,    52,    -1,    33,    52,    -1,    32,
      52,    -1,    39,    52,    -1,    47,    51,    -1,    37,    70,
      -1,    52,    -1,    55,    -1,    -1,    19,    70,    57,   105,
      62,    58,    -1,    -1,    15,    51,    57,   107,    67,    58,
      -1,   101,    -1,    12,    51,    -1,    41,    52,    57,    69,
      58,    -1,    28,    46,    71,    -1,    42,    50,    -1,    43,
      52,   110,    -1,    57,   111,    58,    -1,    -1,    -1,   111,
     112,    -1,    44,    51,    -1,    20,    52,    57,   101,    58,
      -1,    35,    70,    -1,     9,    48,    51,    -1,     9,    48,
      53,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   197,   197,   198,   201,   202,   205,   206,   209,   210,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   236,   237,   238,   239,   240,   241,   242,   245,   246,
     249,   250,   253,   254,   257,   258,   262,   271,   283,   292,
     305,   310,   315,   330,   329,   355,   356,   358,   359,   362,
     375,   380,   385,   390,   395,   403,   408,   413,   430,   447,
     465,   478,   477,   508,   529,   550,   567,   572,   579,   584,
     599,   604,   619,   624,   630,   637,   642,   647,   650,   653,
     656,   659,   662,   665,   669,   698,   699,   705,   704,   729,
     728,   806,   812,   823,   828,   850,   859,   880,   881,   884,
     885,   888,   893,   924,   936,   948
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM", 
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS", 
  "T_ERROR_DOCUMENT", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT", 
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP", 
  "T_SERVER", "T_USERDIR", "T_URL", "T_PIDFILE", "T_LISTEN", "T_FILEDIR", 
  "T_HIDE_VERSION", "T_HIDE_SERVER_NAME", "T_ENCODER", "T_ALLOW", 
  "T_BGCOLOR", "T_TEXT", "T_LINK", "T_ALINK", "T_VLINK", "T_BACKGROUND", 
  "T_DIRECTORYINDEX", "T_IPV6", "T_SHOW", "T_CHROOT", "T_HEADER_FILE", 
  "T_ICONS", "T_AUTH", "T_NAME", "T_METHOD", "T_PASSWDFILE", 
  "T_SSL_CA_LIST_FILE", "T_FROM", "T_SOCKET", "T_NUMBER", "T_PORT", 
  "T_QSTRING", "T_FULLDIR", "T_ID", "T_HTTP_URL", "T_HOSTNAME", "T_IP", 
  "','", "'{'", "'}'", "$accept", "conffile", "lines", "server_lines", 
  "line", "common_line", "server_line", "handler_options", 
  "directory_options", "encoder_options", "auth_options", "id_list", 
  "ip_list", "port", "listen", "document_root", "log", "@1", 
  "log_optional", "tuple_list", "tuple", "hideversion", "hideservername", 
  "mime", "icons", "timeout", "keepalive", "keepalive_max_requests", 
  "ssl_file", "ssl_key_file", "ssl_ca_list_file", "encoder", "@2", 
  "encoder_option", "pidfile", "chroot", "thread_number", "ipv6", "user1", 
  "user2", "group1", "group2", "handler", "handler_option", "host_name", 
  "server", "@3", "directory", "@4", "directory_option", "auth_option", 
  "maybe_auth_option_params", "auth_option_params", "auth_option_param", 
  "userdir", "directoryindex", "errordocument", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,    44,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    59,    60,    60,    61,    61,    62,    62,    63,    63,
      64,    64,    64,    64,    64,    64,    64,    64,    64,    64,
      64,    64,    64,    64,    64,    64,    64,    64,    64,    64,
      64,    65,    65,    65,    65,    65,    65,    65,    66,    66,
      67,    67,    68,    68,    69,    69,    70,    70,    71,    71,
      72,    73,    74,    76,    75,    77,    77,    78,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    90,    92,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   101,   102,   102,   102,   102,   102,
     102,   102,   102,   102,   102,   103,   103,   105,   104,   107,
     106,   108,   108,   108,   108,   109,   109,   110,   110,   111,
     111,   112,   113,   114,   115,   115
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       0,     2,     0,     2,     0,     2,     1,     3,     1,     3,
       2,     2,     2,     0,     4,     0,     3,     0,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     0,     6,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     5,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     1,     0,     6,     0,
       6,     1,     2,     5,     3,     2,     3,     3,     0,     0,
       2,     2,     5,     2,     3,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     3,     4,
       9,     8,    11,    12,    32,    33,    13,    14,    15,    16,
      17,    18,    19,    35,    36,    37,    34,    20,    26,    27,
      28,    21,    22,    23,    24,    10,    31,    25,    29,    30,
      77,    68,    67,    66,     0,    64,    65,    52,    53,    62,
       0,    80,    79,    82,    81,    46,     0,     0,    75,    95,
      96,    51,    60,    61,    70,   113,    78,    76,    63,    69,
      50,     1,     5,   114,   115,    55,    99,     0,    97,     0,
      71,    57,    54,    40,    47,     0,     0,     0,    42,     0,
       0,     0,     6,    84,   112,     0,     0,    56,    58,     0,
       0,     0,   100,   101,    41,    98,     7,    38,     0,     0,
      72,    43,    59,   102,     0,     0,     0,    74,    73,    48,
     104,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    83,    39,     0,     0,    85,    86,    87,    88,
      89,    91,    90,    94,    92,    93,    49,     0,     0,   103,
      45,   105,   108,   109,   106,     0,     0,   107,   110,   111
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    27,    28,   111,    29,    30,    31,   136,   110,   115,
     155,    76,   140,    32,    33,    34,    35,    95,   102,   109,
     118,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,   108,   131,    47,    48,    49,    50,    51,    52,
      53,    54,   107,   153,    81,    55,   105,    56,   103,   124,
     170,   174,   175,   178,    57,    58,    59
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -80
static const yysigned_char yypact[] =
{
      52,   -41,   -35,   -24,   -19,   -17,   -11,    -5,    -7,    -2,
       2,     5,   -14,   -12,    16,    21,    29,   -13,    -1,     0,
      30,    16,     1,    32,    33,    34,    38,    45,    52,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -36,   -80,   -80,   -80,   -80,   -80,
      24,   -80,   -80,   -80,   -80,   -10,    36,    37,   -80,   -80,
     -80,   -80,   -80,   -80,    39,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -80,    41,   -80,    16,   -80,    73,
     -80,   -80,   -80,   -80,   -80,     6,    43,    42,   -80,   -28,
      -6,    -4,   -80,    47,   -80,    -3,    40,   -80,   -80,    48,
      56,    53,   -80,   -80,   -80,   -80,   -80,   -80,    16,    16,
     -80,   -80,   -80,   -80,    54,    59,    82,   -80,   -80,    61,
     -80,   -80,    57,    67,    68,    70,    71,    72,    74,    16,
      75,    79,   -80,   -80,    54,   -38,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80,    81,    80,   -80,
     -80,   -80,    76,   -80,   -80,   -30,    83,   -80,   -80,   -80
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -80,   -80,   -80,   -80,    97,   -80,   -79,   -80,   -80,   -80,
     -80,   -21,   -18,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,    25,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      85,   128,     2,     3,   167,   168,   119,    60,     8,     9,
     106,    11,     2,     3,   176,    93,    61,    94,     8,     9,
     169,    11,   120,    20,   116,   129,   112,    62,   177,    63,
     117,    64,   126,    20,    71,   121,    73,    65,    72,    79,
      74,    25,    80,    66,    67,    91,    97,    82,    83,    86,
      68,    25,   122,    69,   125,   130,    70,     1,     2,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    75,    12,
      13,    14,    15,    77,    16,    17,   104,    18,    19,    20,
      78,    96,    84,    87,    88,    89,    90,    21,    22,   106,
      23,   132,    24,    98,    99,   113,   100,    25,   101,   133,
     114,    26,   134,   142,   127,   135,   143,   137,   138,   139,
     156,   144,   145,   146,   147,   148,   141,   154,   157,   149,
     158,   150,   159,   160,   161,    92,   162,   164,   163,   151,
     165,   171,   172,   173,   179,   123,   166,     0,     0,     0,
     152
};

static const short yycheck[] =
{
      21,     4,     6,     7,    42,    43,    12,    48,    12,    13,
      16,    15,     6,     7,    44,    51,    51,    53,    12,    13,
      58,    15,    28,    27,    52,    28,   105,    51,    58,    48,
      58,    48,   111,    27,    48,    41,    48,    48,    52,    52,
      52,    45,    55,    48,    51,     0,    56,    48,    48,    48,
      52,    45,    58,    51,    58,    58,    51,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    52,    17,
      18,    19,    20,    52,    22,    23,    97,    25,    26,    27,
      51,    57,    52,    51,    51,    51,    48,    35,    36,    16,
      38,    51,    40,    57,    57,    52,    57,    45,    57,    51,
      58,    49,    46,    21,    57,    52,    24,   128,   129,    55,
      53,    29,    30,    31,    32,    33,    57,    56,    51,    37,
      52,    39,    52,    52,    52,    28,    52,    52,   149,    47,
      51,    50,    52,    57,    51,   110,   154,    -1,    -1,    -1,
      58
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    19,    20,    22,    23,    25,    26,
      27,    35,    36,    38,    40,    45,    49,    60,    61,    63,
      64,    65,    72,    73,    74,    75,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    93,    94,    95,
      96,    97,    98,    99,   100,   104,   106,   113,   114,   115,
      48,    51,    51,    48,    48,    48,    48,    51,    52,    51,
      51,    48,    52,    48,    52,    52,    70,    52,    51,    52,
      55,   103,    48,    48,    52,    70,    48,    51,    51,    51,
      48,     0,    63,    51,    53,    76,    57,    56,    57,    57,
      57,    57,    77,   107,    70,   105,    16,   101,    91,    78,
      67,    62,    65,    52,    58,    68,    52,    58,    79,    12,
      28,    41,    58,   101,   108,    58,    65,    57,     4,    28,
      58,    92,    51,    51,    46,    52,    66,    70,    70,    55,
      71,    57,    21,    24,    29,    30,    31,    32,    33,    37,
      39,    47,    58,   102,    56,    69,    53,    51,    52,    52,
      52,    52,    52,    70,    52,    51,    71,    42,    43,    58,
     109,    50,    52,    57,   110,   111,    44,    58,   112,    51
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 46:
#line 263 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;

	   yyval.list = n;
}
    break;

  case 47:
#line 272 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));

	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 48:
#line 284 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;

	   yyval.list = n;
}
    break;

  case 49:
#line 293 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));

	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 50:
#line 306 "read_config_grammar.y"
    {
	   SRV(server)->port = yyvsp[0].number;
}
    break;

  case 51:
#line 311 "read_config_grammar.y"
    {
	   SRV(server)->listen_to = yyvsp[0].string;
}
    break;

  case 52:
#line 316 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;
	   vserver->root = yyvsp[0].string;
	   vserver->root_len = strlen (yyvsp[0].string);

	   /* Check for the endding slash
	    */
	   vserver->root = make_finish_with_slash (vserver->root, &(vserver->root_len));
}
    break;

  case 53:
#line 330 "read_config_grammar.y"
    {
	   ret_t ret;

	   /* Maybe load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load logger module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[0].string, &current_module_info);
}
    break;

  case 54:
#line 344 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, yyvsp[-2].string, current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 59:
#line 363 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_table_add (vserver->logger_props, yyvsp[-1].string, yyvsp[0].string);
}
    break;

  case 60:
#line 376 "read_config_grammar.y"
    {
	   SRV(server)->hideversion = yyvsp[0].number;
}
    break;

  case 61:
#line 381 "read_config_grammar.y"
    {
	   SRV(server)->hideservername = yyvsp[0].number;
}
    break;

  case 62:
#line 386 "read_config_grammar.y"
    {
	   SRV(server)->mime_file = yyvsp[0].string;
}
    break;

  case 63:
#line 391 "read_config_grammar.y"
    {
	   SRV(server)->icons_file = yyvsp[0].string;
}
    break;

  case 64:
#line 396 "read_config_grammar.y"
    {
	   SRV(server)->timeout = yyvsp[0].number;

	   cherokee_buffer_clean  (SRV(server)->timeout_header);
	   cherokee_buffer_add_va (SRV(server)->timeout_header, "Keep-Alive: timeout=%d"CRLF, yyvsp[0].number);
}
    break;

  case 65:
#line 404 "read_config_grammar.y"
    {
	   SRV(server)->keepalive = (yyvsp[0].number == 0) ? false : true;
}
    break;

  case 66:
#line 409 "read_config_grammar.y"
    {
	   SRV(server)->keepalive_max = yyvsp[0].number;
}
    break;

  case 67:
#line 414 "read_config_grammar.y"
    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 PRINT_ERROR ("\"SSLCertificateFile\" overlap: '%s' <- '%s'\n", vsrv->server_cert, yyvsp[0].string);
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: \"SSLCertificateFile\"\n");
#endif
}
    break;

  case 68:
#line 431 "read_config_grammar.y"
    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 PRINT_ERROR ("\"SSLCertificateKeyFile\" overlap: '%s' <- '%s'\n", vsrv->server_key, yyvsp[0].string);
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: \"SSLCertificateKeyFile\"\n");
#endif
}
    break;

  case 69:
#line 448 "read_config_grammar.y"
    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->ca_cert != NULL) {
			 PRINT_ERROR ("\"SSLCAListFile\" overlap: '%s' <- '%s'\n", vsrv->ca_cert, yyvsp[0].string);
			 free (vsrv->ca_cert);
	   }

	   vsrv->ca_cert = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: \"SSLCAListFile\"\n");
#endif
}
    break;

  case 70:
#line 466 "read_config_grammar.y"
    {
	   ret_t ret;

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load encoder module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

}
    break;

  case 71:
#line 478 "read_config_grammar.y"
    {
	   ret_t ret;
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load encoder module '%s'\n", yyvsp[-1].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].string, &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, yyvsp[-1].string, enc);
	   current_encoder_entry = enc;
}
    break;

  case 72:
#line 504 "read_config_grammar.y"
    {
	   current_encoder_entry = NULL;
}
    break;

  case 73:
#line 509 "read_config_grammar.y"
    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 74:
#line 530 "read_config_grammar.y"
    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 75:
#line 551 "read_config_grammar.y"
    {
	   FILE *file;

	   file = fopen (yyvsp[0].string, "w");
	   if (file == NULL) {
			 PRINT_ERROR ("Can't write PID file '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   snprintf (gbl_buffer, gbl_buffer_size, "%d\n", getpid());
	   fwrite (gbl_buffer, 1, strlen(gbl_buffer), file);
	   fclose (file);

	   free (yyvsp[0].string);
}
    break;

  case 76:
#line 568 "read_config_grammar.y"
    {
	   SRV(server)->chroot = yyvsp[0].string;
}
    break;

  case 77:
#line 573 "read_config_grammar.y"
    {
#ifdef HAVE_PTHREAD
	   SRV(server)->ncpus = yyvsp[0].number;
#endif
}
    break;

  case 78:
#line 580 "read_config_grammar.y"
    {
	   SRV(server)->ipv6 = yyvsp[0].number;
}
    break;

  case 79:
#line 585 "read_config_grammar.y"
    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam (yyvsp[0].string);
	   if (pwd == NULL) {
			 PRINT_ERROR ("User '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free (yyvsp[0].string);
}
    break;

  case 80:
#line 600 "read_config_grammar.y"
    {
	   SRV(server)->user = yyvsp[0].number;
}
    break;

  case 81:
#line 605 "read_config_grammar.y"
    {
	   struct group *grp;

	   grp = (struct group *) getgrnam (yyvsp[0].string);
	   if (grp == NULL) {
			 PRINT_ERROR ("Group '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free (yyvsp[0].string);
}
    break;

  case 82:
#line 620 "read_config_grammar.y"
    {
	   SRV(server)->group = yyvsp[0].number;
}
    break;

  case 83:
#line 625 "read_config_grammar.y"
    {
	   yyval.name_ptr.name = yyvsp[-3].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 84:
#line 631 "read_config_grammar.y"
    {
	   yyval.name_ptr.name = yyvsp[0].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 85:
#line 638 "read_config_grammar.y"
    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "url", yyvsp[0].string);
}
    break;

  case 86:
#line 643 "read_config_grammar.y"
    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "filedir", yyvsp[0].string);
}
    break;

  case 87:
#line 648 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "bgcolor", yyvsp[0].string); }
    break;

  case 88:
#line 651 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "text", yyvsp[0].string); }
    break;

  case 89:
#line 654 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "link", yyvsp[0].string); }
    break;

  case 90:
#line 657 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "vlink", yyvsp[0].string); }
    break;

  case 91:
#line 660 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "alink", yyvsp[0].string); }
    break;

  case 92:
#line 663 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "headerfile", yyvsp[0].string); }
    break;

  case 93:
#line 666 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "socket", yyvsp[0].string); }
    break;

  case 94:
#line 670 "read_config_grammar.y"
    {
	   linked_list_t *i;

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_handler_table_entry_set (current_handler_table_entry, i->string, i->string);				    
			 } else {
				    PRINT_ERROR ("Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, free);
}
    break;

  case 96:
#line 700 "read_config_grammar.y"
    {
	   yyval.string = yyvsp[0].string;
}
    break;

  case 97:
#line 705 "read_config_grammar.y"
    {
	   linked_list_t *i = yyvsp[-1].list;
	   CHEROKEE_NEW(vsrv, virtual_server);
	   current_virtual_server = vsrv;

	   /* Add the virtual server to the list
	    */
	   cherokee_list_add (&SRV(server)->vservers, vsrv);

	   /* Add all the alias to the table
	    */
	   while (i != NULL) {
			 cherokee_table_add (SRV(server)->vservers_ref, i->string, vsrv);
			 i = i->next;
	   }
	   free_linked_list (yyvsp[-1].list, NULL);

}
    break;

  case 98:
#line 722 "read_config_grammar.y"
    {

	   current_virtual_server = NULL;
}
    break;

  case 99:
#line 729 "read_config_grammar.y"
    {
	   int name_len;

	   name_len = strlen(yyvsp[-1].string);

	   /* Fill the tmp struct
	    */
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.entry          = handler_table_entry_new ();       /* new! */
	   directory_content_tmp.directory_name = make_finish_with_slash (yyvsp[-1].string, &name_len);
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 100:
#line 743 "read_config_grammar.y"
    {
	   /* Basic checks
	    */
	   if (directory_content_tmp.handler_name == NULL) {
			 PRINT_ERROR ("Directory %s needs a handler; this directory entry is ignored.\n", directory_content_tmp.directory_name);
			 goto out;
	   }

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 cherokee_buffer_make_empty(directory_content_tmp.entry->document_root);
			 cherokee_buffer_add (directory_content_tmp.entry->document_root,
							  directory_content_tmp.document_root,
							  strlen (directory_content_tmp.document_root));
	   }

	   /* Load the module 
	    */
	   {
			 ret_t ret;
			 cherokee_module_info_t *info;

			 ret = cherokee_module_loader_load (SRV(server)->loader, directory_content_tmp.handler_name);
			 if (ret < ret_ok) {
				    PRINT_ERROR ("Error loading module '%s'\n", directory_content_tmp.handler_name);
				    return 1;
			 }

			 ret = cherokee_module_loader_get  (SRV(server)->loader, directory_content_tmp.handler_name, &info);
			 if (ret < ret_ok) {
				    PRINT_ERROR ("Error loading module '%s'\n", directory_content_tmp.handler_name);
				    return 1;
			 }

			 cherokee_handler_table_enty_get_info (directory_content_tmp.entry, info);
			 cherokee_handler_table_add (directory_content_tmp.vserver->plugins,
								    directory_content_tmp.handler_name, 
								    directory_content_tmp.entry);
	   }

	   /* Add to the virtual server "web_dir -> entry" table
	    */
 	   cherokee_virtual_server_set (directory_content_tmp.vserver, 
							  directory_content_tmp.directory_name, 
							  directory_content_tmp.handler_name,
							  directory_content_tmp.entry);

	   /* Clean
	    */
out:
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_handler_table_entry = NULL;
}
    break;

  case 101:
#line 807 "read_config_grammar.y"
    {	   
	   directory_content_tmp.handler_name = yyvsp[0].name_ptr.name;
}
    break;

  case 102:
#line 813 "read_config_grammar.y"
    {
	   int len;
	   char *new_fdir;

	   len = strlen(yyvsp[0].string);
	   new_fdir = make_finish_with_slash (yyvsp[0].string, &len);

	   directory_content_tmp.document_root = new_fdir;
}
    break;

  case 103:
#line 824 "read_config_grammar.y"
    {
}
    break;

  case 104:
#line 829 "read_config_grammar.y"
    {
	   linked_list_t *i, *prev;
	   CHEROKEE_NEW(n, access);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 if (strpbrk(i->string, "/\\") == NULL) {
				    cherokee_access_add_ip (n, i->string);
			 } else {
				    cherokee_access_add_subnet (n, i->string);
			 }
			 
			 free (i->string);
			 prev = i;
			 i = i->next;
			 free (prev);
	   }
	   directory_content_tmp.entry->access = n;
}
    break;

  case 105:
#line 851 "read_config_grammar.y"
    {
	   cherokee_buffer_t *realm;
	   realm = directory_content_tmp.entry->auth_realm;

	   cherokee_buffer_add (realm, yyvsp[0].string, strlen(yyvsp[0].string));
	   free (yyvsp[0].string);
}
    break;

  case 106:
#line 860 "read_config_grammar.y"
    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load validator module '%s'\n", yyvsp[-1].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].string, &info);

	   if (info->type != cherokee_validator) {
			 PRINT_ERROR ("ERROR: %s is not a validator module!!\n", yyvsp[-1].string);
	   }

	   directory_content_tmp.entry->validator_new_func = info->new_func;
}
    break;

  case 111:
#line 889 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "file", yyvsp[0].string); }
    break;

  case 112:
#line 894 "read_config_grammar.y"
    {
	   ret_t ret;
	   int   len;
	   cherokee_module_info_t         *info;
	   cherokee_handler_table_entry_t *dir;

	   /* Set the users public directory
	    */
	   len = strlen(yyvsp[-3].string);
	   SRV(server)->userdir = make_finish_with_slash (yyvsp[-3].string, &len);

	   /* Build the handler
	    */
	   dir = handler_table_entry_new ();

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].name_ptr.name);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can not load handler module '%s'\n", yyvsp[-1].name_ptr.name);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].name_ptr.name, &info);

	   cherokee_handler_table_enty_get_info (dir, info);
	   SRV(server)->userdir_handler = dir;

	   free (yyvsp[-1].name_ptr.name);
}
    break;

  case 113:
#line 925 "read_config_grammar.y"
    {
	   linked_list_t *i = yyvsp[0].list;

	   while (i != NULL) {
			 cherokee_list_add_tail (&SRV(server)->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, NULL);
}
    break;

  case 114:
#line 937 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;
	   
	   if ((yyvsp[-1].number < 400) || (yyvsp[-1].number > 417))
	   {
			 PRINT_ERROR ("Error: Ignoring incorrect error code. Valid: 400..417. '%s'\n", yyvsp[0].string);
	   }

	   vsrv->error_document400[yyvsp[-1].number-400].file = yyvsp[0].string;
}
    break;

  case 115:
#line 949 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;
	   
	   if ((yyvsp[-1].number < 400) || (yyvsp[-1].number > 417))
	   {
			 PRINT_ERROR ("Error: Ignoring incorrect error code. Valid: 400..417. '%s'\n", yyvsp[0].string);
	   }

	   vsrv->error_document400[yyvsp[-1].number-400].url = yyvsp[0].string;
}
    break;


    }

/* Line 999 of yacc.c.  */
#line 2221 "read_config_grammar.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 960 "read_config_grammar.y"



