/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_URL_H__
#define __CHEROKEE_URL_H__

#include "common.h"

#include <netinet/in.h>

#include "list.h"
#include "buffer.h"

typedef struct {	
	cherokee_buffer_t  *host;
	cherokee_buffer_t  *request;
	uint16_t            port;
} cherokee_url_t;

#define URL(u)           ((cherokee_url_t *)(u))
#define URL_HOST(u)      (URL(u)->host)
#define URL_REQUEST(u)   (URL(u)->request)
#define URL_PORT(u)      (URL(u)->port)


ret_t cherokee_url_new   (cherokee_url_t **url);
ret_t cherokee_url_free  (cherokee_url_t  *url);

ret_t cherokee_url_parse        (cherokee_url_t *url, char *url_string);
ret_t cherokee_url_build_string (cherokee_url_t *url, cherokee_buffer_t *buf);

ret_t cherokee_url_print (cherokee_url_t *url);

#endif /* __CHEROKEE_URL_H__ */

