/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_SERVER_CONFIG_H__
#define __CHEROKEE2_SERVER_CONFIG_H__

#include "common.h"

typedef struct {
	void *server;

	int   port;
	int   log;
	int   timeout;
	int   keepalive;

	uid_t user;
	uid_t user_orig;
	gid_t group;
	gid_t group_orig;

	char *document_root;	
	char *mimetypes_file;
} cherokee_server_conf_t;

/*
 * Global config object
 */
extern cherokee_server_conf_t *_cherokee_global_config;


ret_t cherokee_server_conf_new         (cherokee_server_conf_t **cnf);
ret_t cherokee_server_conf_free        (cherokee_server_conf_t  *cnf);
ret_t cherokee_server_conf_get_default (cherokee_server_conf_t **cnf);

ret_t cherokee_server_conf_read      (cherokee_server_conf_t  *cnf, char *sentence);
ret_t cherokee_server_conf_read_file (cherokee_server_conf_t  *cnf, char *filename);


/* Functions for YACC
 */
ret_t cherokee_server_conf_set_document_root (cherokee_server_conf_t *cnf, char *docroot);


#endif /* __CHEROKEE2_SERVER_CONFIG_H__ */
