/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "mime.h"
#include "server_config.h"


static int              _mime_is_init = 0;
static cherokee_mime_t *_mime_global  = NULL;


static ret_t 
cherokee_mime_new  (cherokee_mime_t **mime)
{
	   cherokee_mime_t *n = (cherokee_mime_t *) malloc (sizeof(cherokee_mime_t));
	   return_if_fail (n!=NULL, ret_nomem);

	   cherokee_table_init(&n->table);

	   *mime = n;
	   return ret_ok;
}


ret_t
cherokee_mime_free (cherokee_mime_t *mime)
{
	cherokee_table_free2 (&mime->table, free);
	free (mime);

	return ret_ok;
}


static ret_t 
cherokee_mime_load (cherokee_mime_t *mime, char *filename)
{
	   FILE   *f;
	   char    ext[32];
	   char    mime_string[80];

	   f = fopen (filename, "r");
	   return_if_fail (f!=NULL, ret_file_not_found);

	   while (!feof(f)) {
			 fgets (gbl_buffer, gbl_buffer_size, f);

			 /* Empty
			  */
			 if (strlen(gbl_buffer) < 3) 
				    continue;

			 /* Comments
			  */
			 if (gbl_buffer[0] == '#')
				    continue;

			 /* Split the line
			  */
			 sscanf (gbl_buffer, "%s\t%s", ext, mime_string);

			 /* Add to table
			  */
			 cherokee_table_add (&mime->table, strdup(ext), strdup(mime_string));
	   }
	   
	   fclose(f);
	   return ret_ok;
}


char * 
cherokee_mime_get (cherokee_mime_t *mime, char *ext)
{
	   return cherokee_table_get (&mime->table, ext);
}


ret_t 
cherokee_mime_get_default (cherokee_mime_t **mime)
{
	   *mime = _mime_global;
	   return ret_ok;
}


/* 	Library init function
 */

void
mime_init (void)
{
	cherokee_server_conf_t *config;

	if (_mime_is_init) 
		return;
	
	cherokee_mime_new (&_mime_global);
	cherokee_server_conf_get_default (&config);

	if (config->mimetypes_file != NULL) {
		cherokee_mime_load (_mime_global, config->mimetypes_file);
	} else {
		cherokee_mime_load (_mime_global, CHEROKEE_DATADIR"/mime_types.txt");
	}
	
	_mime_is_init = 1;
}
