/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <signal.h>

#include "server.c"

cherokee_server_t *srv = NULL;

void
restart_server (int code)
{
	cherokee_server_free (srv);

	cherokee_server_conf_read_file (srv->config, CHEROKEE_CONFDIR"/cherokee.conf");

	cherokee_server_new (&srv);
	cherokee_server_init (&srv);
}


int
main (int argc, char **argv)
{
	ret_t ret;
	
	
	ret = cherokee_server_new (&srv);
	if (ret != ret_ok) return 1;
	
	ret = cherokee_server_conf_read_file (srv->config, CHEROKEE_CONFDIR"/cherokee.conf");
	if (ret != ret_ok) return 2;
	
	signal (SIGPIPE, SIG_IGN);
	signal (SIGHUP, restart_server);
	
	cherokee_server_init (srv);
	for (;;) {
		cherokee_server_step(srv);
	}
	
	cherokee_server_free (srv);

	return 0;
}
