%{
/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "server_config.h"
#include "server.h"

extern char *yytext;
extern int   yylineno;

cherokee_server_conf_t *_cherokee_yacc_conf = NULL;
%}

%union {
	   char *string;
	   int   number;
}

%token T_QUOTE
%token T_TIMEOUT T_KEEPALIVE T_DOCUMENT_ROOT T_LOG T_MIME_FILE T_DIRECTORY T_HANDLER

%token <number> T_NUMBER T_PORT 
%token <string> T_QSTRING T_FULLDIR T_ID


%%

conffile: /* Empty */
	| lines
	;

lines: line
	| lines line
	;

line : T_PORT T_NUMBER 
{
	   _cherokee_yacc_conf->port = $2;
};

line : T_DOCUMENT_ROOT T_FULLDIR
{
	   cherokee_server_conf_set_document_root (_cherokee_yacc_conf, (char *)$2);
};

line : T_LOG T_NUMBER
{
	   cherokee_server_log (SRV(_cherokee_yacc_conf->server), $2);
};

line : T_MIME_FILE T_FULLDIR
{
	   _cherokee_yacc_conf->mimetypes_file = strdup((char *)$2);
};

line : T_DIRECTORY T_FULLDIR '{' T_HANDLER T_ID '}'
{
	   cherokee_server_set (SRV(_cherokee_yacc_conf->server), (char *)$2, (char *)$5);

	   /* FIXME: Not sure of this
	    */
	   free ($2);
	   free ($5);
};

line : T_TIMEOUT T_NUMBER
{
	   _cherokee_yacc_conf->timeout = $2;
};

line : T_KEEPALIVE T_NUMBER
{
	   _cherokee_yacc_conf->keepalive = $2;
}



%%

int 
yyerror(char* msg)
{
        printf("Error: '%s', line %d, symbol '%s'\n", msg, yylineno, yytext);
}
