/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdio.h>
#include <stdlib.h>

#include "server_config.h"
#include "server.h"
#include "read_config_yacc.h"

cherokee_server_conf_t *_cherokee_global_config = NULL;


ret_t 
cherokee_server_conf_new (cherokee_server_conf_t **cnf)
{
	cherokee_server_conf_t *n = (cherokee_server_conf_t *) malloc(sizeof(cherokee_server_conf_t));
	return_if_fail (n!=NULL, ret_nomem);


	/* Set the default config reference
	 */
	if (_cherokee_global_config == NULL) {
		_cherokee_global_config = n;
	}
	
	/* Set the default values
	 */
	n->server         = NULL;
	n->port           = 80;
	n->log            = 0;
	n->timeout        = 15;
	n->keepalive      = 1;
	n->document_root  = NULL;
	n->mimetypes_file = NULL;

	*cnf = n;
	return ret_ok;
}


ret_t 
cherokee_server_conf_free (cherokee_server_conf_t *cnf)
{
	if (cnf->document_root != NULL) {
		free (cnf->document_root);
	}

	if (cnf->mimetypes_file != NULL) {
		free (cnf->mimetypes_file);
	}

	free (cnf);

	return ret_ok;
}


ret_t 
cherokee_server_conf_get_default (cherokee_server_conf_t **cnf)
{
	if (_cherokee_global_config == NULL) {
		return ret_error;
	}

	*cnf = _cherokee_global_config;
	return ret_ok;
}


ret_t 
cherokee_server_conf_read (cherokee_server_conf_t  *cnf, char *sentence)
{
	extern cherokee_server_conf_t *_cherokee_yacc_conf;

	/* Make yacc fill this object
	 */
	_cherokee_yacc_conf = cnf;

	/* Scan the sentence
	 */
	yy_scan_string (sentence);

	return ret_ok;
}


ret_t 
cherokee_server_conf_read_file (cherokee_server_conf_t  *cnf, char *filename)
{
	extern FILE *yyin;
	extern cherokee_server_conf_t *_cherokee_yacc_conf;

	/* Make yacc fill this object
	 */
	_cherokee_yacc_conf = cnf;

	/* Set the file to read
	 */
	yyin = fopen (filename, "r");
	return_if_fail (yyin!=NULL, ret_file_not_found);

	/* Cooooome on :-)
	 */
	yyparse ();

	if (yyin != NULL)
		fclose (yyin);

	return ret_ok;
}


ret_t 
cherokee_server_conf_set_document_root (cherokee_server_conf_t *cnf, char *docroot)
{
	/* Set the document root string
	 */
	if (cnf->document_root != NULL) free (cnf->document_root);
	cnf->document_root = strdup (docroot);
	

	/* Move to that directory
	 */
	if (chdir (docroot) == -1) {
		fprintf (stderr, "Can't chdir() to DocumentRoot: '%s'\n", docroot);
		return ret_error;
	}

	return ret_ok;
}
