/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_CONNECTION_H__
#define __CHEROKEE2_CONNECTION_H__

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else 
#include <time.h>
#endif

#include "list.h"
#include "http.h"
#include "common.h"
#include "buffer.h"
#include "handler.h"
#include "handler_file.h"


typedef enum {
	stat_reading = 0,
	stat_writing = 1,
	stat_closed
} cherokee_connection_status_t;


typedef struct {
	struct list_head              list;
	
	int                           socket;
	
	cherokee_connection_status_t  status;
	cherokee_http_version_t       version;
	cherokee_http_method_t        method;

	cherokee_http_t               error_code;
	int                           header_sent;
	
	cherokee_buffer_t            *buffer;
	cherokee_handler_t           *handler;
	char                         *request;
	char                         *request_local;

	time_t                        timeout;
	int                           keep_alive;
} cherokee_connection_t;


#define CONN(x)  ((cherokee_connection_t *)(x))


ret_t cherokee_connection_new          (cherokee_connection_t **cnt);
ret_t cherokee_connection_free         (cherokee_connection_t  *cnt);
ret_t cherokee_connection_clean        (cherokee_connection_t  *cnt);
ret_t cherokee_connection_mrproper     (cherokee_connection_t  *cnt);
ret_t cherokee_connection_set_socket   (cherokee_connection_t  *cnt, int socket);

/* 	Send & Recv
 */
ret_t cherokee_connection_recv         (cherokee_connection_t  *cnt);
ret_t cherokee_connection_send         (cherokee_connection_t  *cnt);
ret_t cherokee_connection_close        (cherokee_connection_t  *cnt);

/* 	Sending
 */
ret_t cherokee_connection_send_header        (cherokee_connection_t *cnt);
ret_t cherokee_connection_send_response_page (cherokee_connection_t *cnt);

/*	Iteration
 */
ret_t cherokee_connection_open_request  (cherokee_connection_t  *cnt, func_new_t new_handler_func);
ret_t cherokee_connection_step          (cherokee_connection_t  *cnt);
ret_t cherokee_connection_reading_check (cherokee_connection_t  *cnt);

/* 	Headers
 */
int   cherokee_connection_eoh          (cherokee_connection_t  *cnt);
ret_t cherokee_connection_parse_header (cherokee_connection_t  *cnt);


#endif /* __CHEROKEE2_CONNECTION_H__  */
