/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "mime.h"

ret_t 
cherokee_mime_new  (cherokee_mime_t **mime)
{
	   cherokee_mime_t *n = (cherokee_mime_t *) malloc (sizeof(cherokee_mime_t));
	   return_if_fail (n!=NULL, ret_nomem);

	   cherokee_table_init(&n->table);

	   *mime = n;
	   return ret_ok;
}


ret_t 
cherokee_mime_free (cherokee_mime_t *mime)
{
	   cherokee_table_clean (&mime->table);

	   free(mime);

	   return ret_ok;
}


ret_t 
cherokee_mime_load (cherokee_mime_t *mime, char *filename)
{
	   FILE   *f;
	   char    buf[1024];
	   size_t  readed;
	   char   *ext;
	   char   *mime;

	   f = fopen (filename, "r");
	   if (f == NULL) {
			 return ret_file_not_found;
	   }

	   while (!feof(f)) {
			 readed = fread (buf, 1, 1024, f);

			 /* Empty
			  */
			 if (readed < 3) 
				    continue;

			 /* Comments
			  */
			 if (buf[0] == '#')
				    continue;

			 /* Split the line
			  */
			 sscanf (buf, "%s\t%s", &mime, &ext);

			 printf ("mime='%s' ext='%s'\n", mime, ext);
	   }
	   
	   fclose(f);
	   return ret_ok;
}
