/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Summary;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.zookeeper.metrics.Counter;
import org.apache.zookeeper.metrics.Gauge;
import org.apache.zookeeper.metrics.MetricsContext;
import org.apache.zookeeper.metrics.MetricsProvider;
import org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import org.apache.zookeeper.metrics.Summary;
import org.apache.zookeeper.metrics.SummarySet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsProvider
implements MetricsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMetricsProvider.class);
    private static final String LABEL = "key";
    private static final String[] LABELS = new String[]{"key"};
    private final CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;
    private int port = 7000;
    private boolean exportJvmInfo = true;
    private Server server;
    private final MetricsServletImpl servlet = new MetricsServletImpl();
    private final Context rootContext = new Context();

    public void configure(Properties configuration) throws MetricsProviderLifeCycleException {
        LOG.info("Initializing metrics, configuration: {}", (Object)configuration);
        this.port = Integer.parseInt(configuration.getProperty("httpPort", "7000"));
        this.exportJvmInfo = Boolean.parseBoolean(configuration.getProperty("exportJvmInfo", "true"));
    }

    public void start() throws MetricsProviderLifeCycleException {
        try {
            LOG.info("Starting /metrics HTTP endpoint at port {} exportJvmInfo: {}", (Object)this.port, (Object)this.exportJvmInfo);
            if (this.exportJvmInfo) {
                DefaultExports.initialize();
            }
            this.server = new Server(this.port);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)this.servlet), "/metrics");
            this.server.start();
        }
        catch (Exception err) {
            LOG.error("Cannot start /metrics server", (Throwable)err);
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception suppressed) {
                    err.addSuppressed(suppressed);
                }
                finally {
                    this.server = null;
                }
            }
            throw new MetricsProviderLifeCycleException((Throwable)err);
        }
    }

    MetricsServletImpl getServlet() {
        return this.servlet;
    }

    public MetricsContext getRootContext() {
        return this.rootContext;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception err) {
                LOG.error("Cannot safely stop Jetty server", (Throwable)err);
            }
            finally {
                this.server = null;
            }
        }
    }

    public void dump(BiConsumer<String, Object> sink) {
        this.sampleGauges();
        Enumeration samplesFamilies = this.collectorRegistry.metricFamilySamples();
        while (samplesFamilies.hasMoreElements()) {
            Collector.MetricFamilySamples samples = (Collector.MetricFamilySamples)samplesFamilies.nextElement();
            samples.samples.forEach(sample -> {
                String key = PrometheusMetricsProvider.buildKeyForDump(sample);
                sink.accept(key, sample.value);
            });
        }
    }

    private static String buildKeyForDump(Collector.MetricFamilySamples.Sample sample) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(sample.name);
        if (sample.labelNames.size() > 0) {
            keyBuilder.append('{');
            for (int i = 0; i < sample.labelNames.size(); ++i) {
                if (i > 0) {
                    keyBuilder.append(',');
                }
                keyBuilder.append((String)sample.labelNames.get(i));
                keyBuilder.append("=\"");
                keyBuilder.append((String)sample.labelValues.get(i));
                keyBuilder.append('\"');
            }
            keyBuilder.append('}');
        }
        return keyBuilder.toString();
    }

    private void sampleGauges() {
        this.rootContext.gauges.values().forEach(rec$ -> ((PrometheusGaugeWrapper)rec$).sample());
    }

    public void resetAllValues() {
    }

    class MetricsServletImpl
    extends MetricsServlet {
        MetricsServletImpl() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            PrometheusMetricsProvider.this.sampleGauges();
            super.doGet(req, resp);
        }
    }

    private class PrometheusLabelledSummary
    implements SummarySet {
        private final io.prometheus.client.Summary inner;
        private final String name;

        public PrometheusLabelledSummary(String name, MetricsContext.DetailLevel level) {
            this.name = name;
            this.inner = level == MetricsContext.DetailLevel.ADVANCED ? (io.prometheus.client.Summary)((Summary.Builder)io.prometheus.client.Summary.build((String)name, (String)name).labelNames(LABELS)).quantile(0.5, 0.05).quantile(0.9, 0.01).quantile(0.99, 0.001).register(PrometheusMetricsProvider.this.collectorRegistry) : (io.prometheus.client.Summary)((Summary.Builder)io.prometheus.client.Summary.build((String)name, (String)name).labelNames(LABELS)).quantile(0.5, 0.05).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        public void add(String key, long value) {
            try {
                ((Summary.Child)this.inner.labels(new String[]{key})).observe((double)value);
            }
            catch (IllegalArgumentException err) {
                LOG.error("invalid value {} for metric {} with key {}", new Object[]{value, this.name, key, err});
            }
        }
    }

    private class PrometheusSummary
    implements Summary {
        private final io.prometheus.client.Summary inner;
        private final String name;

        public PrometheusSummary(String name, MetricsContext.DetailLevel level) {
            this.name = name;
            this.inner = level == MetricsContext.DetailLevel.ADVANCED ? (io.prometheus.client.Summary)io.prometheus.client.Summary.build((String)name, (String)name).quantile(0.5, 0.05).quantile(0.9, 0.01).quantile(0.99, 0.001).register(PrometheusMetricsProvider.this.collectorRegistry) : (io.prometheus.client.Summary)io.prometheus.client.Summary.build((String)name, (String)name).quantile(0.5, 0.05).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        public void add(long delta) {
            try {
                this.inner.observe((double)delta);
            }
            catch (IllegalArgumentException err) {
                LOG.error("invalid delta {} for metric {}", new Object[]{delta, this.name, err});
            }
        }
    }

    private class PrometheusGaugeWrapper {
        private final io.prometheus.client.Gauge inner;
        private final Gauge gauge;
        private final String name;

        public PrometheusGaugeWrapper(String name, Gauge gauge, io.prometheus.client.Gauge prev) {
            this.name = name;
            this.gauge = gauge;
            this.inner = prev != null ? prev : (io.prometheus.client.Gauge)io.prometheus.client.Gauge.build((String)name, (String)name).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        private void sample() {
            Number value = this.gauge.get();
            this.inner.set(value != null ? value.doubleValue() : 0.0);
        }

        private void unregister() {
            PrometheusMetricsProvider.this.collectorRegistry.unregister((Collector)this.inner);
        }
    }

    private class PrometheusCounter
    implements Counter {
        private final io.prometheus.client.Counter inner;
        private final String name;

        public PrometheusCounter(String name) {
            this.name = name;
            this.inner = (io.prometheus.client.Counter)io.prometheus.client.Counter.build((String)name, (String)name).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        public void add(long delta) {
            try {
                this.inner.inc((double)delta);
            }
            catch (IllegalArgumentException err) {
                LOG.error("invalid delta {} for metric {}", new Object[]{delta, this.name, err});
            }
        }

        public long get() {
            return (long)this.inner.get();
        }
    }

    private class Context
    implements MetricsContext {
        private final ConcurrentMap<String, PrometheusGaugeWrapper> gauges = new ConcurrentHashMap<String, PrometheusGaugeWrapper>();
        private final ConcurrentMap<String, PrometheusCounter> counters = new ConcurrentHashMap<String, PrometheusCounter>();
        private final ConcurrentMap<String, PrometheusSummary> basicSummaries = new ConcurrentHashMap<String, PrometheusSummary>();
        private final ConcurrentMap<String, PrometheusSummary> summaries = new ConcurrentHashMap<String, PrometheusSummary>();
        private final ConcurrentMap<String, PrometheusLabelledSummary> basicSummarySets = new ConcurrentHashMap<String, PrometheusLabelledSummary>();
        private final ConcurrentMap<String, PrometheusLabelledSummary> summarySets = new ConcurrentHashMap<String, PrometheusLabelledSummary>();

        private Context() {
        }

        public MetricsContext getContext(String name) {
            return this;
        }

        public Counter getCounter(String name) {
            return this.counters.computeIfAbsent(name, x$0 -> new PrometheusCounter((String)x$0));
        }

        public void registerGauge(String name, Gauge gauge) {
            Objects.requireNonNull(name);
            this.gauges.compute(name, (id, prev) -> new PrometheusGaugeWrapper((String)id, gauge, prev != null ? ((PrometheusGaugeWrapper)prev).inner : null));
        }

        public void unregisterGauge(String name) {
            PrometheusGaugeWrapper existing = (PrometheusGaugeWrapper)this.gauges.remove(name);
            if (existing != null) {
                existing.unregister();
            }
        }

        public Summary getSummary(String name, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummaries.computeIfAbsent(name, n -> {
                    if (this.summaries.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary as " + n);
                    }
                    return new PrometheusSummary(name, detailLevel);
                });
            }
            return this.summaries.computeIfAbsent(name, n -> {
                if (this.basicSummaries.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary as " + n);
                }
                return new PrometheusSummary(name, detailLevel);
            });
        }

        public SummarySet getSummarySet(String name, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummarySets.computeIfAbsent(name, n -> {
                    if (this.summarySets.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary set as " + n);
                    }
                    return new PrometheusLabelledSummary(name, detailLevel);
                });
            }
            return this.summarySets.computeIfAbsent(name, n -> {
                if (this.basicSummarySets.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary set as " + n);
                }
                return new PrometheusLabelledSummary(name, detailLevel);
            });
        }
    }
}

