/*
 * RedirectTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1998-2002 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.1
 * Created by suhler on 98/09/14
 * Last modified by suhler on 02/10/01 16:36:41
 */

package sunlabs.brazil.template;

/**
 * [<i>Deprecated, use the AddHeaderTemplate instead</i>.]<br>
 * Template class for redirecting an html page
 * This class is used by the TemplateHandler
 * @author		Stephen Uhler
 * @version		@(#)RedirectTemplate.java	2.1
 */

public class RedirectTemplate
    extends Template
{
    String redirect;
    
    /**
     * Look for a redirect tag, change it to an HREF, and remember where
     * to redirect to (e.g. <code>&lt;redirect http://some.where.com&gt;)
     * </code>
     */

    public void
    redirect(RewriteContext hr)
    {
	redirect = hr.getArgs();

	hr.append("<A HREF=" + redirect + ">" + redirect + "</A>");
    }

    /**
     * adjust the response headers to reflect redirection, if supplied.
     * Otherwise, ignore this request.
     */

    public boolean
    done(RewriteContext hr)
    {
	if (redirect != null) {
	    hr.request.addHeader("location", redirect);
	    hr.request.setStatus(302);
	    return true;
    	} else {
	    return false;
	}
    }
}
