/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.mixin;

import javax.xml.namespace.QName;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.mime.PartBlob;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.intf.AxiomText;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomTextMixin
implements AxiomText {
    private TextContent getTextContent(boolean force) {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return (TextContent)content;
            }
            if (force) {
                TextContent textContent = new TextContent((String)content);
                this.coreSetCharacterData(textContent, AxiomSemantics.INSTANCE);
                return textContent;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final boolean isBinary() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isBinary();
    }

    public final void setBinary(boolean binary) {
        TextContent textContent = this.getTextContent(binary);
        if (textContent != null) {
            textContent.setBinary(binary);
        }
    }

    public final boolean isOptimized() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isOptimize();
    }

    public final void setOptimize(boolean optimize) {
        TextContent textContent = this.getTextContent(optimize);
        if (textContent != null) {
            textContent.setOptimize(optimize);
        }
    }

    public final String getText() throws OMException {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final char[] getTextCharacters() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).toCharArray();
            }
            return ((String)content).toCharArray();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final boolean isCharacters() {
        return false;
    }

    public final QName getTextAsQName() throws OMException {
        return ((OMElement)this.getParent()).resolveQName(this.getText());
    }

    public final OMNamespace getNamespace() {
        QName qname = this.getTextAsQName();
        if (qname == null) {
            return null;
        }
        String namespaceURI = qname.getNamespaceURI();
        return namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, qname.getPrefix());
    }

    public final Blob getBlob() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).getBlob();
            }
            throw new OMException("No DataHandler available");
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final String getContentID() {
        return this.getTextContent(true).getContentID();
    }

    public final void buildWithAttachments() {
        Blob blob;
        if (this.isOptimized() && (blob = this.getBlob()) instanceof PartBlob) {
            ((PartBlob)blob).getPart().fetch();
        }
    }

    public final void setContentID(String cid) {
        this.getTextContent(true).setContentID(cid);
    }
}

