
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Check how strongType is derived from itself.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#TypeInfo-isDerivedFrom">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#TypeInfo-isDerivedFrom</a>
*/
public final class typeinfoisderivedfrom28 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public typeinfoisderivedfrom28(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.schemaValidating
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList;
      Element elem;
      TypeInfo typeInfo;
      boolean isDerived;
      String typeName;
      doc = (Document) load("hc_staff", false);
      elemList = doc.getElementsByTagName("strong");
      elem = (Element) elemList.item(0);
      typeInfo = elem.getSchemaTypeInfo();
      assertNotNull("typeInfoNotNull", typeInfo);
      typeName = typeInfo.getTypeName();
      assertEquals("typeName", "strongType", typeName);
      isDerived = typeInfo.isDerivedFrom("http://www.w3.org/1999/xhtml", "strongType", 1);
      assertTrue("notDerivedFromSelfRestriction", isDerived);
      isDerived = typeInfo.isDerivedFrom("http://www.w3.org/1999/xhtml", "strongType", 14);
      assertFalse("notDerivedFromSelfOther", isDerived);
isDerived = typeInfo.isDerivedFrom("http://www.w3.org/1999/xhtml", "strongType", 15);
      assertTrue("notDerivedFromSelfAll", isDerived);
      isDerived = typeInfo.isDerivedFrom("http://www.w3.org/1999/xhtml", "strongType", 0);
      assertTrue("notDerivedFromSelfAny", isDerived);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/typeinfoisderivedfrom28";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(typeinfoisderivedfrom28.class, args);
   }
}

