
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method setTextContent has no effect when the node is defined to be null.
 *  
 *  Using setTextContent on a new Element node, attempt to set its content to ELEMENT.
 *  Retreive the textContent and verify if it is was set to ELEMENT.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-textContent">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-textContent</a>
*/
public final class nodesettextcontent10 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodesettextcontent10(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware,
org.w3c.domts.DocumentBuilderSetting.expandEntityReferences
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element elem;
      Text txt;
      Comment comment;
      EntityReference entRef;
      CDATASection cdata;
      ProcessingInstruction pi;
      String textContent;
      Node appendedChild;
      doc = (Document) load("hc_staff", false);
      elem = doc.createElementNS("http://www.w3.org/DOM/Test", "dom3:elem");
      txt = doc.createTextNode("Text ");
      comment = doc.createComment("Comment ");
      entRef = doc.createEntityReference("ent1");
      pi = doc.createProcessingInstruction("PIT", "PIData ");
      cdata = doc.createCDATASection("CData");
      appendedChild = elem.appendChild(txt);
      appendedChild = elem.appendChild(comment);
      appendedChild = elem.appendChild(entRef);
      appendedChild = elem.appendChild(pi);
      appendedChild = elem.appendChild(cdata);
      elem.setTextContent("ELEMENT");
      textContent = elem.getTextContent();
      assertEquals("nodesettextcontent10", "ELEMENT", textContent);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodesettextcontent10";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodesettextcontent10.class, args);
   }
}

