
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Checks behavior of "error-handler" configuration parameter.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-error-handler">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-error-handler</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-getParameter">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-getParameter</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-setParameter">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-setParameter</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=544">http://www.w3.org/Bugs/Public/show_bug.cgi?id=544</a>
*/
public final class domconfigerrorhandler1 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    */
   public domconfigerrorhandler1(final DOMTestDocumentBuilderFactory factory)  {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    }

     /**
      *    Inner class implementation for variable errorHandler 
      */
      private static class DOMErrorHandlerN10049
           extends org.w3c.domts.DOMTestInnerClass 
           implements DOMErrorHandler {
       /**
        * Constructor
        * @param test test case
        */
        public DOMErrorHandlerN10049(DOMTestCase test) { 
        super(test);
           }
   
        /**
         *    
This method is called on the error handler when an error occurs.
If an exception is thrown from this method, it is considered to be equivalent of returningtrue.

         * @param error The error object that describes the error. This object may be reused by the DOM implementation across multiple calls to thehandleErrormethod.
         * @return If thehandleErrormethod returnsfalse, the DOM implementation should stop the current processing when possible. If the method returnstrue, the processing may continue depending onDOMError.severity.
         */
         public boolean handleError(DOMError error) {
                return true;
      }
}

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      DOMImplementation domImpl;
      Document doc;
      DOMConfiguration domConfig;
      DocumentType nullDocType = null;

      boolean canSet;
      DOMErrorHandler origHandler;
      DOMErrorHandler state;
      String parameter = "eRrOr-handler";
      DOMErrorHandler errorHandler = new DOMErrorHandlerN10049(this);
      domImpl = getImplementation();
      doc = domImpl.createDocument("http://www.w3.org/1999/xhtml", "html", nullDocType);
      domConfig = doc.getDomConfig();
      origHandler = (DOMErrorHandler) domConfig.getParameter(parameter);
      canSet = domConfig.canSetParameter(parameter, ((Object) /*DOMErrorHandler */errorHandler));
      assertTrue("canSetNewHandler", canSet);
      canSet = domConfig.canSetParameter(parameter, ((Object) /*DOMErrorHandler */origHandler));
      assertTrue("canSetOrigHandler", canSet);
      domConfig.setParameter(parameter, ((Object) /*DOMErrorHandler */errorHandler));
      state = (DOMErrorHandler) domConfig.getParameter(parameter);
      assertSame("setToNewHandlerEffective", errorHandler, state);
domConfig.setParameter(parameter, ((Object) /*DOMErrorHandler */origHandler));
      state = (DOMErrorHandler) domConfig.getParameter(parameter);
      assertSame("setToOrigHandlerEffective", origHandler, state);
canSet = domConfig.canSetParameter(parameter, Boolean.TRUE);
      
      if (canSet) {
          domConfig.setParameter(parameter, Boolean.TRUE);
      }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/domconfigerrorhandler1";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(domconfigerrorhandler1.class, args);
   }
}

