/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response.filter;

import java.util.HashMap;
import org.apache.wicket.Application;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AjaxServerAndClientTimeFilter
implements IResponseFilter {
    private static Logger log = LoggerFactory.getLogger(AjaxServerAndClientTimeFilter.class);

    @Override
    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int headIndex = responseBuffer.indexOf("<head>");
        int bodyIndex = responseBuffer.indexOf("</body>");
        int ajaxStart = responseBuffer.indexOf("<ajax-response>");
        int ajaxEnd = responseBuffer.indexOf("</ajax-response>");
        long timeTaken = System.currentTimeMillis() - RequestCycle.get().getStartTime();
        if (headIndex != -1 && bodyIndex != -1) {
            responseBuffer.insert(bodyIndex, this.scriptTag("window.defaultStatus=" + this.getStatusString(timeTaken, "ServerAndClientTimeFilter.statustext") + ";"));
            responseBuffer.insert(headIndex + 6, this.scriptTag("clientTimeVariable = new Date().getTime();"));
        } else if (ajaxStart != -1 && ajaxEnd != -1) {
            responseBuffer.insert(ajaxEnd, this.headerContribution("window.defaultStatus=" + this.getStatusString(timeTaken, "ajax.ServerAndClientTimeFilter.statustext") + ";"));
            responseBuffer.insert(ajaxStart + 15, this.headerContribution("clientTimeVariable = new Date().getTime();"));
        }
        log.info(timeTaken + "ms server time taken for request " + String.valueOf(RequestCycle.get().getRequest().getUrl()) + " response size: " + responseBuffer.length());
        return responseBuffer;
    }

    private String scriptTag(String script) {
        AppendingStringBuffer buffer = new AppendingStringBuffer(250);
        buffer.append("\n");
        buffer.append("<script type=\"text/javascript\">\n/*<![CDATA[*/\n");
        buffer.append(script);
        buffer.append("\n/*]]>*/\n</script>\n").append("\n");
        return buffer.toString();
    }

    private String headerContribution(String script) {
        AppendingStringBuffer buffer = new AppendingStringBuffer(250);
        buffer.append("<header-contribution><![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
        buffer.append(script);
        buffer.append("</head>]]></header-contribution>");
        return buffer.toString();
    }

    private String getStatusString(long timeTaken, String resourceKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("servertime", (double)timeTaken / 1000.0 + "s");
        map.put("clienttime", "' + (new Date().getTime() - clientTimeVariable)/1000 +  's");
        return Application.get().getResourceSettings().getLocalizer().getString(resourceKey, null, Model.of(map), "'Server parsetime: ${servertime}, Client parsetime: ${clienttime}'");
    }
}

