/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.util.string.AppendingStringBuffer;

public class JavaScriptStripper {
    private static final int REGULAR_TEXT = 1;
    private static final int STRING_SINGLE_QUOTE = 2;
    private static final int STRING_DOUBLE_QUOTES = 3;
    private static final int WHITE_SPACE = 4;
    private static final int LINE_COMMENT = 5;
    private static final int MULTILINE_COMMENT = 6;
    private static final int REG_EXP = 7;
    private static final int TEMPLATE_LITERAL = 8;

    private int getPrevCount(String s, int fromIndex, char c) {
        int count = 0;
        --fromIndex;
        while (fromIndex >= 0 && s.charAt(fromIndex--) == c) {
            ++count;
        }
        return count;
    }

    public String stripCommentsAndWhitespace(String original) {
        AppendingStringBuffer result = new AppendingStringBuffer(original.length() / 2);
        int state = 1;
        boolean wasNewLineInWhitespace = false;
        for (int i = 0; i < original.length(); ++i) {
            int count;
            char prev;
            char c = original.charAt(i);
            char next = i < original.length() - 1 ? original.charAt(i + 1) : (char)'\u0000';
            char c2 = prev = i > 0 ? original.charAt(i - 1) : (char)'\u0000';
            if (state == 4) {
                if (c == '\n' && !wasNewLineInWhitespace) {
                    result.append("\n");
                    wasNewLineInWhitespace = true;
                }
                if (Character.isWhitespace(next)) continue;
                state = 1;
                continue;
            }
            if (state == 1) {
                if (c == '/' && next == '/' && prev != '\\') {
                    state = 5;
                    continue;
                }
                if (c == '/' && next == '*') {
                    state = 6;
                    ++i;
                    continue;
                }
                if (c == '/') {
                    for (int idx = result.length() - 1; idx > 0; --idx) {
                        char tmp = result.charAt(idx);
                        if (Character.isWhitespace(tmp)) {
                            continue;
                        }
                        if (tmp == '=' || tmp == '(' || tmp == '{' || tmp == ':' || tmp == ',' || tmp == '[' || tmp == ';' || tmp == '!') {
                            state = 7;
                        }
                        break;
                    }
                } else if (Character.isWhitespace(c) && Character.isWhitespace(next)) {
                    if (c == '\n' || next == '\n') {
                        c = '\n';
                        wasNewLineInWhitespace = true;
                    } else {
                        c = ' ';
                        wasNewLineInWhitespace = false;
                    }
                    state = 4;
                } else if (c == '\'') {
                    state = 2;
                } else if (c == '\"') {
                    state = 3;
                } else if (c == '`') {
                    state = 8;
                }
                result.append(c);
                continue;
            }
            if (state == 5 && (c == '\n' || c == '\r')) {
                state = 1;
                result.append(c);
                continue;
            }
            if (state == 6 && c == '*' && next == '/') {
                state = 1;
                ++i;
                continue;
            }
            if (state == 2) {
                count = this.getPrevCount(original, i, '\\');
                if (c == '\'' && count % 2 == 0) {
                    state = 1;
                }
                result.append(c);
                continue;
            }
            if (state == 3) {
                count = this.getPrevCount(original, i, '\\');
                if (c == '\"' && count % 2 == 0) {
                    state = 1;
                }
                result.append(c);
                continue;
            }
            if (state == 7) {
                count = this.getPrevCount(original, i, '\\');
                if (c == '/' && count % 2 == 0) {
                    state = 1;
                }
                result.append(c);
            }
            if (state != 8) continue;
            count = this.getPrevCount(original, i, '\\');
            if (c == '`' && count % 2 == 0) {
                state = 1;
            }
            result.append(c);
        }
        return result.toString();
    }
}

