/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.util.tester;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.util.tester.TestWebSocketConnection;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.tester.WicketTester;

abstract class TestWebSocketProcessor
extends AbstractWebSocketProcessor {
    public TestWebSocketProcessor(HttpServletRequest request, WebApplication application) {
        super(request, application);
    }

    public TestWebSocketProcessor(WicketTester wicketTester, Page page) {
        super(TestWebSocketProcessor.createRequest(wicketTester, page), (WebApplication)page.getApplication());
    }

    public TestWebSocketProcessor(WicketTester wicketTester, String resourceName) {
        super(TestWebSocketProcessor.createRequest(wicketTester, resourceName), wicketTester.getApplication());
    }

    private static HttpServletRequest createRequest(WicketTester wicketTester, Page page) {
        Args.notNull((Object)page, (String)"page");
        MockHttpServletRequest request = TestWebSocketProcessor.createRequest(wicketTester);
        request.addParameter("pageId", page.getId());
        return request;
    }

    private static HttpServletRequest createRequest(WicketTester wicketTester, String resourceName) {
        Args.notNull((Object)resourceName, (String)"resourceName");
        MockHttpServletRequest request = TestWebSocketProcessor.createRequest(wicketTester);
        request.addParameter("resourceName", resourceName);
        return request;
    }

    private static MockHttpServletRequest createRequest(WicketTester wicketTester) {
        WebApplication application = wicketTester.getApplication();
        MockHttpSession httpSession = wicketTester.getHttpSession();
        MockHttpServletRequest request = new MockHttpServletRequest((Application)application, (HttpSession)httpSession, null);
        request.addParameter("wicket-ajax-baseurl", ".");
        return request;
    }

    @Override
    public void onOpen(Object connection) {
        this.onConnect(new TestWebSocketConnection(){

            @Override
            protected void onOutMessage(String message) {
                TestWebSocketProcessor.this.onOutMessage(message);
            }

            @Override
            protected void onOutMessage(byte[] message, int offset, int length) {
                TestWebSocketProcessor.this.onOutMessage(message, offset, length);
            }

            @Override
            public void sendMessage(IWebSocketPushMessage message) {
                TestWebSocketProcessor.this.broadcastMessage(message);
            }
        });
    }

    protected abstract void onOutMessage(String var1);

    protected abstract void onOutMessage(byte[] var1, int var2, int var3);
}

