/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.encoding;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(UrlDecoder.class);
    private final boolean decodePlus;
    public static final UrlDecoder QUERY_INSTANCE = new UrlDecoder(true);
    public static final UrlDecoder PATH_INSTANCE = new UrlDecoder(false);

    private UrlDecoder(boolean decodePlus) {
        this.decodePlus = decodePlus;
    }

    public String decode(String s, String enc) {
        Args.notNull(enc, "enc");
        try {
            return this.decode(s, Charset.forName(enc));
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new RuntimeException(new UnsupportedEncodingException(enc));
        }
    }

    public String decode(String s, Charset charset) {
        if (Strings.isEmpty(s)) {
            return s;
        }
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        Args.notNull(charset, "charset");
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(this.decodePlus ? (char)' ' : '+');
                    ++i;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            LOG.info("Incomplete trailing escape (%) pattern in '%s'. The escape character (%) will be ignored.", (Object)s);
                            ++i;
                            continue block6;
                        }
                        sb.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        LOG.info("Illegal hex characters in escape (%) pattern in '{}'. The escape character (%) will be ignored. NumberFormatException: {} ", (Object)s, (Object)e.getMessage());
                        ++i;
                    }
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString().replace("\u0000", "NULL");
    }
}

