/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.tomcat7;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketConnection;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatWebSocketConnection
extends AbstractWebSocketConnection {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatWebSocketConnection.class);
    private final WsOutbound connection;
    private boolean closed = false;

    public TomcatWebSocketConnection(WsOutbound connection, AbstractWebSocketProcessor webSocketProcessor) {
        super(webSocketProcessor);
        this.connection = (WsOutbound)Args.notNull((Object)connection, (String)"connection");
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close(int code, String reason) {
        if (this.isOpen()) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.wrap(reason.getBytes("UTF-8"));
                this.connection.close(0, byteBuffer);
            }
            catch (IOException iox) {
                LOG.error("An error occurred while closing WebSocket connection with initial reason: " + reason, (Throwable)iox);
            }
            this.closed = true;
        }
    }

    public IWebSocketConnection sendMessage(String message) throws IOException {
        this.checkClosed();
        CharBuffer buffer = CharBuffer.wrap(message);
        this.connection.writeTextMessage(buffer);
        return this;
    }

    public TomcatWebSocketConnection sendMessage(byte[] message, int offset, int length) throws IOException {
        this.checkClosed();
        ByteBuffer buffer = ByteBuffer.wrap(message, offset, length);
        this.connection.writeBinaryMessage(buffer);
        return this;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed.");
        }
    }
}

