/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class Node<T>
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String OTHER_CLASS_KEY = CssUtils.key(Node.class, (String)"other");
    public static final String EXPANDED_CLASS_KEY = CssUtils.key(Node.class, (String)"expanded");
    public static final String COLLAPSED_CLASS_KEY = CssUtils.key(Node.class, (String)"collapsed");
    public static final String CONTENT_ID = "content";
    private AbstractTree<T> tree;

    public Node(String id, AbstractTree<T> tree, IModel<T> model) {
        super(id, model);
        this.tree = tree;
        MarkupContainer junction = this.createJunctionComponent("junction");
        junction.add(new Behavior[]{new StyleBehavior()});
        this.add(new Component[]{junction});
        Component content = this.createContent(CONTENT_ID, model);
        if (!content.getId().equals(CONTENT_ID)) {
            throw new IllegalArgumentException("content must have component id equal to Node.CONTENT_ID");
        }
        this.add(new Component[]{content});
    }

    public IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public T getModelObject() {
        return (T)this.getModel().getObject();
    }

    protected MarkupContainer createJunctionComponent(String id) {
        return new AjaxFallbackLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                Node.this.toggle();
            }

            public boolean isEnabled() {
                return Node.this.tree.getProvider().hasChildren(Node.this.getModelObject());
            }
        };
    }

    protected void toggle() {
        T t = this.getModelObject();
        if (this.tree.getState(t) == AbstractTree.State.EXPANDED) {
            this.tree.collapse(t);
        } else {
            this.tree.expand(t);
        }
    }

    protected abstract Component createContent(String var1, IModel<T> var2);

    protected String getStyleClass() {
        T t = this.getModelObject();
        if (this.tree.getProvider().hasChildren(t)) {
            if (this.tree.getState(t) == AbstractTree.State.EXPANDED) {
                return this.getExpandedStyleClass(t);
            }
            return this.getCollapsedStyleClass();
        }
        return this.getOtherStyleClass();
    }

    protected String getExpandedStyleClass(T t) {
        return this.getString(EXPANDED_CLASS_KEY);
    }

    protected String getCollapsedStyleClass() {
        return this.getString(COLLAPSED_CLASS_KEY);
    }

    protected String getOtherStyleClass() {
        return this.getString(OTHER_CLASS_KEY);
    }

    private static class StyleBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        private StyleBehavior() {
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            Node node = (Node)component.getParent();
            String styleClass = node.getStyleClass();
            if (styleClass != null) {
                tag.put("class", (CharSequence)styleClass);
            }
        }
    }
}

