/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidatorAdapter;
import org.apache.wicket.validation.validator.PatternValidator;

public class HTML5Attributes
extends Behavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        if (component instanceof AbstractTextComponent) {
            this.onInput((AbstractTextComponent)component, tag);
        } else if (component instanceof Button) {
            this.onButton((Button)component, tag);
        }
    }

    protected void onInput(AbstractTextComponent<?> input, ComponentTag tag) {
        IModel<String> label;
        if (input.isRequired()) {
            tag.put("required", "required");
        }
        if ((label = input.getLabel()) != null && label.getObject() != null) {
            tag.put("placeholder", label.getObject());
        }
        for (IValidator validator : input.getValidators()) {
            if (validator instanceof ValidatorAdapter) {
                validator = ((ValidatorAdapter)validator).getValidator();
            }
            if (!(validator instanceof PatternValidator)) continue;
            tag.put("pattern", ((PatternValidator)validator).getPattern().toString());
        }
    }

    protected void onButton(Button button, ComponentTag tag) {
        if (!button.getDefaultFormProcessing()) {
            tag.put("formnovalidate", "formnovalidate");
        }
    }

    public static class InstantiationListener
    implements IComponentInstantiationListener {
        @Override
        public void onInstantiation(Component component) {
            if (component instanceof FormComponent) {
                component.add(new HTML5Attributes());
            }
        }
    }
}

