/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.TagUtils;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.HeaderPartContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.AbstractMarkupSourcingStrategy;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;

public abstract class AssociatedMarkupSourcingStrategy
extends AbstractMarkupSourcingStrategy {
    private boolean noMoreWicketHeadTagsAllowed = false;
    private final String tagName;

    public AssociatedMarkupSourcingStrategy(String tagName) {
        this.tagName = (String)Args.notNull((Object)tagName, (String)"tagName");
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
    }

    protected final void renderAssociatedMarkup(Component component) {
        ((MarkupContainer)component).renderAssociatedMarkup(this.tagName, "Markup for a " + this.tagName + " component must begin a tag like '<wicket:" + this.tagName + ">'");
    }

    @Override
    public IMarkupFragment getMarkup(MarkupContainer parent, Component child) {
        Args.notNull((Object)this.tagName, (String)"tagName");
        IMarkupFragment associatedMarkup = parent.getAssociatedMarkup();
        if (associatedMarkup == null) {
            throw new MarkupNotFoundException("Failed to find markup file associated. " + Classes.simpleName(parent.getClass()) + ": " + parent.toString());
        }
        IMarkupFragment markup = this.findStartTag(associatedMarkup);
        if (markup == null) {
            throw new MarkupNotFoundException("Expected to find <wicket:" + this.tagName + "> in associated markup file. Markup: " + associatedMarkup.toString());
        }
        if (child == null) {
            return markup;
        }
        associatedMarkup = markup.find(child.getId());
        if (associatedMarkup != null) {
            return associatedMarkup;
        }
        associatedMarkup = this.searchMarkupInTransparentResolvers(parent, child);
        if (associatedMarkup != null) {
            return associatedMarkup;
        }
        return this.findMarkupInAssociatedFileHeader(parent, child);
    }

    private final IMarkupFragment findStartTag(IMarkupFragment markup) {
        MarkupStream stream = new MarkupStream(markup);
        while (stream.skipUntil(ComponentTag.class)) {
            ComponentTag tag = stream.getTag();
            if (tag.isOpen() || tag.isOpenClose()) {
                WicketTag wtag;
                if (tag instanceof WicketTag && this.tagName.equalsIgnoreCase((wtag = (WicketTag)tag).getName())) {
                    return stream.getMarkupFragment();
                }
                stream.skipToMatchingCloseTag(tag);
            }
            stream.next();
        }
        return null;
    }

    public IMarkupFragment findMarkupInAssociatedFileHeader(MarkupContainer container, Component child) {
        Markup markup = container.getAssociatedMarkup();
        IMarkupFragment childMarkup = null;
        MarkupStream stream = new MarkupStream(markup);
        while (stream.skipUntil(ComponentTag.class) && childMarkup == null) {
            ComponentTag tag = stream.getTag();
            if (TagUtils.isWicketHeadTag(tag)) {
                if (tag.getMarkupClass() == null) {
                    childMarkup = stream.getMarkupFragment().find(child.getId());
                }
            } else if (TagUtils.isHeadTag(tag)) {
                childMarkup = stream.getMarkupFragment().find(child.getId());
            }
            if (tag.isOpen() && !tag.hasNoCloseTag()) {
                stream.skipToMatchingCloseTag(tag);
            }
            stream.next();
        }
        return childMarkup;
    }

    @Override
    public void renderHead(Component component, HtmlHeaderContainer container) {
        if (!(component instanceof WebMarkupContainer)) {
            throw new WicketRuntimeException(Classes.simpleName(component.getClass()) + " can only be associated with WebMarkupContainer.");
        }
        this.renderHeadFromAssociatedMarkupFile((WebMarkupContainer)component, container);
    }

    public final void renderHeadFromAssociatedMarkupFile(WebMarkupContainer container, HtmlHeaderContainer htmlContainer) {
        this.noMoreWicketHeadTagsAllowed = false;
        MarkupStream markupStream = container.getAssociatedMarkupStream(false);
        if (markupStream == null) {
            return;
        }
        this.noMoreWicketHeadTagsAllowed = false;
        while (this.nextHeaderMarkup(markupStream) != -1) {
            String headerId = this.getHeaderId(container, markupStream);
            HeaderPartContainer headerPart = this.getHeaderPart(container, headerId, markupStream.getMarkupFragment());
            if (headerPart != null && htmlContainer.okToRenderComponent(headerPart.getScope(), headerPart.getId())) {
                headerPart.setParent(htmlContainer);
                headerPart.render();
            }
            markupStream.skipComponent();
        }
    }

    private String getHeaderId(Component container, MarkupStream markupStream) {
        Class<? extends Component> markupClass = markupStream.getTag().getMarkupClass();
        if (markupClass == null) {
            markupClass = markupStream.getContainerClass();
        }
        StringBuilder builder = new StringBuilder(100);
        builder.append('_');
        builder.append(Classes.simpleName(markupClass));
        if (container.getVariation() != null) {
            builder.append(container.getVariation());
        }
        builder.append("Header");
        builder.append(markupStream.getCurrentIndex());
        return builder.toString();
    }

    private final HeaderPartContainer getHeaderPart(WebMarkupContainer container, String id, IMarkupFragment markup) {
        WicketTag wTag;
        MarkupElement element = markup.get(0);
        if (element instanceof WicketTag && (wTag = (WicketTag)element).isHeadTag() && wTag.getNamespace() != null) {
            return new HeaderPartContainer(id, container, markup);
        }
        throw new WicketRuntimeException("Programming error: expected a WicketTag: " + markup.toString());
    }

    private final int nextHeaderMarkup(MarkupStream associatedMarkupStream) {
        if (associatedMarkupStream == null) {
            return -1;
        }
        MarkupElement elem = associatedMarkupStream.get();
        while (elem != null) {
            ComponentTag tag;
            if (elem instanceof WicketTag) {
                tag = (WicketTag)elem;
                if (tag.isOpen() && ((WicketTag)tag).isHeadTag()) {
                    if (this.noMoreWicketHeadTagsAllowed) {
                        throw new MarkupException("<wicket:head> tags are only allowed before <body>, </head>, <wicket:panel> etc. tag");
                    }
                    return associatedMarkupStream.getCurrentIndex();
                }
                if (tag.isOpen() && (((WicketTag)tag).isPanelTag() || ((WicketTag)tag).isBorderTag() || ((WicketTag)tag).isExtendTag())) {
                    this.noMoreWicketHeadTagsAllowed = true;
                }
            } else if (elem instanceof ComponentTag) {
                tag = (ComponentTag)elem;
                if (tag.isClose() && TagUtils.isHeadTag(tag)) {
                    this.noMoreWicketHeadTagsAllowed = true;
                } else if (tag.isOpen() && TagUtils.isBodyTag(tag)) {
                    this.noMoreWicketHeadTagsAllowed = true;
                }
            }
            elem = associatedMarkupStream.next();
        }
        return -1;
    }
}

