/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ClientSideImageMap
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String CIRCLE = "circle";
    private static final String POLYGON = "polygon";
    private static final String RECTANGLE = "rect";
    private RepeatingView areas;

    public ClientSideImageMap(String id, Image image) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(AttributeModifier.replace("name", new PropertyModel(this, "markupId")));
        image.add(AttributeModifier.replace("usemap", new UsemapModel()));
        this.areas = new RepeatingView("area");
        this.add(this.areas);
    }

    private String circleCoordinates(int x, int y, int radius) {
        return x + "," + y + "," + radius;
    }

    private String polygonCoordinates(int ... coordinates) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < coordinates.length; ++i) {
            buffer.append(coordinates[i]);
            if (i >= coordinates.length - 1) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    private String rectangleCoordinates(int x1, int y1, int x2, int y2) {
        return x1 + "," + y1 + "," + x2 + "," + y2;
    }

    private String shapeCoordinates(Shape shape) {
        StringBuilder sb = new StringBuilder();
        PathIterator pi = shape.getPathIterator(null, 1.0);
        float[] coords = new float[6];
        float[] lastMove = new float[2];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    sb.append(Math.round(coords[0]));
                    sb.append(",");
                    sb.append(Math.round(coords[1]));
                    lastMove[0] = coords[0];
                    lastMove[1] = coords[1];
                    break;
                }
                case 1: {
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    sb.append(Math.round(coords[0]));
                    sb.append(",");
                    sb.append(Math.round(coords[1]));
                    break;
                }
                case 4: {
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    sb.append(Math.round(lastMove[0]));
                    sb.append(",");
                    sb.append(Math.round(lastMove[1]));
                }
            }
            pi.next();
        }
        return sb.toString();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "map");
        super.onComponentTag(tag);
    }

    public String newChildId() {
        return this.areas.newChildId();
    }

    public ClientSideImageMap addCircleArea(AbstractLink link, int x, int y, int radius) {
        this.areas.add(link);
        link.add(new Area(this.circleCoordinates(x, y, radius), CIRCLE));
        return this;
    }

    public ClientSideImageMap addPolygonArea(AbstractLink link, int ... coordinates) {
        this.areas.add(link);
        link.add(new Area(this.polygonCoordinates(coordinates), POLYGON));
        return this;
    }

    public ClientSideImageMap addRectangleArea(AbstractLink link, int x1, int y1, int x2, int y2) {
        this.areas.add(link);
        link.add(new Area(this.rectangleCoordinates(x1, y1, x2, y2), RECTANGLE));
        return this;
    }

    public ClientSideImageMap addShapeArea(AbstractLink link, Shape shape) {
        this.areas.add(link);
        link.add(new Area(this.shapeCoordinates(shape), POLYGON));
        return this;
    }

    private class UsemapModel
    extends Model<String> {
        private static final long serialVersionUID = 1L;

        private UsemapModel() {
        }

        @Override
        public String getObject() {
            return "#" + ClientSideImageMap.this.getMarkupId();
        }
    }

    private static class Area
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final String coordinates;
        private final String type;

        protected Area(String coordinates, String type) {
            this.coordinates = coordinates;
            this.type = type;
        }

        @Override
        public void onComponentTag(Component component, ComponentTag tag) {
            tag.put("shape", this.type);
            tag.put("coords", this.coordinates);
        }
    }
}

