/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image;

import java.lang.reflect.Method;
import org.apache.wicket.Component;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.image.resource.LocalizedImageResource;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;

public class Image
extends WebComponent
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private final LocalizedImageResource localizedImageResource = new LocalizedImageResource(this);

    protected Image(String id) {
        super(id);
    }

    public Image(String id, ResourceReference resourceReference) {
        this(id, resourceReference, null);
    }

    public Image(String id, ResourceReference resourceReference, PageParameters resourceParameters) {
        super(id);
        this.setImageResourceReference(resourceReference, resourceParameters);
    }

    public Image(String id, IResource imageResource) {
        super(id);
        this.setImageResource(imageResource);
    }

    public Image(String id, IModel<?> model) {
        super(id, model);
    }

    public Image(String id, String string) {
        this(id, new Model<String>(string));
    }

    @Override
    public void onResourceRequested() {
        this.localizedImageResource.onResourceRequested(null);
    }

    public void setImageResource(IResource imageResource) {
        this.localizedImageResource.setResource(imageResource);
    }

    public void setImageResourceReference(ResourceReference resourceReference) {
        this.localizedImageResource.setResourceReference(resourceReference);
    }

    public void setImageResourceReference(ResourceReference resourceReference, PageParameters parameters) {
        this.localizedImageResource.setResourceReference(resourceReference, parameters);
    }

    @Override
    public Component setDefaultModel(IModel<?> model) {
        this.localizedImageResource.setResourceReference(null);
        this.localizedImageResource.setResource(null);
        return super.setDefaultModel(model);
    }

    protected IResource getImageResource() {
        return this.localizedImageResource.getResource();
    }

    protected ResourceReference getImageResourceReference() {
        return this.localizedImageResource.getResourceReference();
    }

    @Override
    protected IModel<?> initModel() {
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        ResourceReference resourceReference;
        this.checkComponentTag(tag, "img");
        super.onComponentTag(tag);
        IResource resource = this.getImageResource();
        if (resource != null) {
            this.localizedImageResource.setResource(resource);
        }
        if ((resourceReference = this.getImageResourceReference()) != null) {
            this.localizedImageResource.setResourceReference(resourceReference);
        }
        this.localizedImageResource.setSrcAttribute(tag);
        if (this.shouldAddAntiCacheParameter()) {
            this.addAntiCacheParameter(tag);
        }
    }

    protected boolean shouldAddAntiCacheParameter() {
        return this.getRequestCycle().find(AjaxRequestTarget.class) != null;
    }

    protected void addAntiCacheParameter(ComponentTag tag) {
        String url = tag.getAttributes().getString("src");
        url = url + (url.contains("?") ? "&" : "?");
        url = url + "antiCache=" + System.currentTimeMillis();
        tag.put("src", url);
    }

    @Override
    protected boolean getStatelessHint() {
        return (this.getImageResource() == null || this.getImageResource() == this.localizedImageResource.getResource()) && this.localizedImageResource.isStateless();
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
    }

    @Override
    public boolean canCallListenerInterface(Method method) {
        boolean isResource;
        boolean bl = isResource = method != null && IResourceListener.class.isAssignableFrom(method.getDeclaringClass());
        if (isResource && this.isVisibleInHierarchy()) {
            return true;
        }
        return super.canCallListenerInterface(method);
    }
}

