/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring;

import java.lang.ref.WeakReference;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class SpringBeanLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<Class<?>> beanTypeCache;
    private final String beanTypeName;
    private String beanName;
    private ISpringContextLocator springContextLocator;
    private Boolean singletonCache = null;

    public SpringBeanLocator(Class<?> beanType, ISpringContextLocator locator) {
        this(null, beanType, locator);
    }

    public SpringBeanLocator(String beanName, Class<?> beanType, ISpringContextLocator locator) {
        Args.notNull((Object)locator, (String)"locator");
        Args.notNull(beanType, (String)"beanType");
        this.beanTypeCache = new WeakReference(beanType);
        this.beanTypeName = beanType.getName();
        this.springContextLocator = locator;
        this.beanName = beanName;
        this.springContextLocator = locator;
    }

    public boolean isSingletonBean() {
        if (this.singletonCache == null) {
            this.singletonCache = this.getSpringContext().isSingleton(this.getBeanName());
        }
        return this.singletonCache;
    }

    public Class<?> getBeanType() {
        Class clazz;
        Class clazz2 = clazz = this.beanTypeCache == null ? null : (Class)this.beanTypeCache.get();
        if (clazz == null) {
            clazz = WicketObjects.resolveClass((String)this.beanTypeName);
            this.beanTypeCache = new WeakReference<Class>(clazz);
            if (clazz == null) {
                throw new RuntimeException("SpringBeanLocator could not find class [" + this.beanTypeName + "] needed to locate the [" + (this.beanName != null ? this.beanName : "bean name not specified") + "] bean");
            }
        }
        return clazz;
    }

    public Object locateProxyTarget() {
        ApplicationContext context = this.getSpringContext();
        return this.lookupSpringBean(context, this.beanName, this.getBeanType());
    }

    private ApplicationContext getSpringContext() {
        ApplicationContext context = this.springContextLocator.getSpringContext();
        if (context == null) {
            throw new IllegalStateException("spring application context locator returned null");
        }
        return context;
    }

    public final String getBeanName() {
        return this.beanName;
    }

    public final ISpringContextLocator getSpringContextLocator() {
        return this.springContextLocator;
    }

    private Object lookupSpringBean(ApplicationContext ctx, String name, Class<?> clazz) {
        try {
            if (name == null) {
                return ctx.getBean(clazz);
            }
            return ctx.getBean(name, clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalStateException("bean with name [" + name + "] and class [" + clazz.getName() + "] not found", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpringBeanLocator) {
            SpringBeanLocator other = (SpringBeanLocator)obj;
            return this.beanTypeName.equals(other.beanTypeName) && Objects.equal((Object)this.beanName, (Object)other.beanName);
        }
        return false;
    }

    public int hashCode() {
        int hashcode = this.beanTypeName.hashCode();
        if (this.getBeanName() != null) {
            hashcode += 127 * this.beanName.hashCode();
        }
        return hashcode;
    }
}

