/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.wicket.Application;
import org.apache.wicket.IInitializer;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.jmx.wrapper.ApplicationSettings;
import org.apache.wicket.jmx.wrapper.DebugSettings;
import org.apache.wicket.jmx.wrapper.MarkupSettings;
import org.apache.wicket.jmx.wrapper.PageSettings;
import org.apache.wicket.jmx.wrapper.RequestCycleSettings;
import org.apache.wicket.jmx.wrapper.RequestLogger;
import org.apache.wicket.jmx.wrapper.ResourceSettings;
import org.apache.wicket.jmx.wrapper.SecuritySettings;
import org.apache.wicket.jmx.wrapper.SessionSettings;
import org.apache.wicket.jmx.wrapper.StoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer
implements IInitializer {
    private static final Logger log = LoggerFactory.getLogger(Initializer.class);
    private MBeanServer mbeanServer = null;
    private final List<ObjectName> registered = new ArrayList<ObjectName>();

    public void destroy(Application application) {
        for (ObjectName objectName : this.registered) {
            try {
                this.mbeanServer.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void init(Application application) {
        try {
            String name = application.getName();
            String agentId = null;
            try {
                agentId = System.getProperty("wicket.mbean.server.agentid");
            }
            catch (SecurityException e) {
                log.warn("not allowed to read property wicket.mbean.server.agentid due to security settings; ignoring");
            }
            if (agentId != null) {
                ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(agentId);
                if (!mbeanServers.isEmpty()) {
                    this.mbeanServer = mbeanServers.get(0);
                } else {
                    log.error("unable to find mbean server with agent id {}", (Object)agentId);
                }
            }
            if (this.mbeanServer == null) {
                String impl = null;
                try {
                    impl = System.getProperty("wicket.mbean.server.class");
                }
                catch (SecurityException e) {
                    log.warn("Not allowed to read property wicket.mbean.server.class due to security settings: {}. Ignoring", (Object)e.getMessage());
                }
                if (impl != null) {
                    ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
                    if (!mbeanServers.isEmpty()) {
                        for (MBeanServer mbs : mbeanServers) {
                            if (!mbs.getClass().getName().equals(impl)) continue;
                            this.mbeanServer = mbs;
                            break;
                        }
                    }
                    if (this.mbeanServer == null) {
                        log.error("unable to find mbean server of type '{}'", (Object)impl);
                    }
                }
            }
            if (this.mbeanServer == null) {
                this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            log.info("registering Wicket mbeans with server '{}'", (Object)this.mbeanServer);
            String domain = "org.apache.wicket.app." + name;
            ObjectName appBeanName = new ObjectName(domain + ":type=Application");
            String tempDomain = domain;
            int i = 0;
            while (this.mbeanServer.isRegistered(appBeanName)) {
                tempDomain = name + "-" + i++;
                appBeanName = new ObjectName(tempDomain + ":type=Application");
            }
            domain = tempDomain;
            org.apache.wicket.jmx.wrapper.Application appBean = new org.apache.wicket.jmx.wrapper.Application(application);
            this.register(application, appBean, appBeanName);
            this.register(application, new ApplicationSettings(application), new ObjectName(domain + ":type=Application,name=ApplicationSettings"));
            this.register(application, new DebugSettings(application), new ObjectName(domain + ":type=Application,name=DebugSettings"));
            this.register(application, new MarkupSettings(application), new ObjectName(domain + ":type=Application,name=MarkupSettings"));
            this.register(application, new ResourceSettings(application), new ObjectName(domain + ":type=Application,name=ResourceSettings"));
            this.register(application, new PageSettings(application), new ObjectName(domain + ":type=Application,name=PageSettings"));
            this.register(application, new RequestCycleSettings(application), new ObjectName(domain + ":type=Application,name=RequestCycleSettings"));
            this.register(application, new SecuritySettings(application), new ObjectName(domain + ":type=Application,name=SecuritySettings"));
            this.register(application, new SessionSettings(application), new ObjectName(domain + ":type=Application,name=SessionSettings"));
            this.register(application, new StoreSettings(application), new ObjectName(domain + ":type=Application,name=StoreSettings"));
            RequestLogger sessionsBean = new RequestLogger(application);
            ObjectName sessionsBeanName = new ObjectName(domain + ":type=RequestLogger");
            this.register(application, sessionsBean, sessionsBeanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public String toString() {
        return "Wicket JMX initializer";
    }

    private <T> void register(final Application application, T o, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        StandardMBean bean = new StandardMBean(o, o.getClass().getInterfaces()[0]){

            @Override
            public Object getAttribute(String attribute) {
                return this.withApplication(() -> super.getAttribute(attribute));
            }

            @Override
            public void setAttribute(Attribute attribute) {
                this.withApplication(() -> {
                    super.setAttribute(attribute);
                    return null;
                });
            }

            @Override
            public AttributeList setAttributes(AttributeList attributes) {
                return this.withApplication(() -> super.setAttributes(attributes));
            }

            @Override
            public Object invoke(String actionName, Object[] params, String[] signature) {
                return this.withApplication(() -> super.invoke(actionName, params, signature));
            }

            private <R> R withApplication(Callable<R> callable) {
                boolean existed = ThreadContext.exists();
                if (!existed) {
                    ThreadContext.setApplication((Application)application);
                }
                try {
                    R r = callable.call();
                    return r;
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException((Throwable)ex);
                }
                finally {
                    if (!existed) {
                        ThreadContext.detach();
                    }
                }
            }
        };
        this.mbeanServer.registerMBean(bean, objectName);
        this.registered.add(objectName);
    }
}

